@extends('layout.default')

@section('title', 'Team Lead Dashboard')

{{-- 🔌 Neon variables + Toasts --}}
@includeIf('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
    <style>
        /* ====== Core Neon Tokens (متوافقة مع partial.theme.neon-vars) ====== */
        :root {

            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        body {
            background: var(--body-bg);
            color: var(--text-main);
        }

        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }

        .sub-muted {
            color: var(--muted);
        }

        /* ====== Card ====== */
        .card-n {

            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
        }

        .card-n .card-body {
            padding: 18px;
        }

        /* ====== Buttons ====== */
        .neon-btn {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            padding: .55rem 1rem;
            border-radius: 10px;
            backdrop-filter: blur(4px);
            transition: .2s ease;
            box-shadow: var(--glow);
            text-decoration: none !important;
        }

        .neon-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .neon-btn-success {
            border-color: rgba(42, 252, 152, .45);
        }

        .neon-chip {
            display: inline-flex;
            gap: .45rem;
            align-items: center;
            font-size: .8rem;
            color: #bcd6ff;
            padding: .28rem .6rem;
            border-radius: 999px;
            background: rgba(0, 224, 255, .08);
            border: 1px solid var(--border-2);
        }

        /* ====== Filter controls ====== */
        .flt-wrap {
            display: flex;
            gap: .6rem;
            flex-wrap: wrap;
            align-items: center;
        }

        .flt-select,
        .flt-date {
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .5rem .7rem;
            min-width: 160px;
            outline: none;
        }

        .flt-select:focus,
        .flt-date:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
        }

        /* ====== Department card ====== */
        .dept-card {
            border: 1px solid var(--border);
            border-radius: 12px;
            padding: 16px;
            transition: .2s;
        }

        .dept-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 26px rgba(0, 0, 0, .35), var(--glow);
        }

        .dept-name {
            font-size: .9rem;
            letter-spacing: .4px;
            text-transform: uppercase;
            color: var(--neon-2);
            text-shadow: 0 0 10px rgba(0, 224, 255, .3);
        }

        .attendance-percentage .h4 {
            font-size: 2rem;
            color: #fff;
        }

        /* الرقم أبيض */
        .present-badge {
            background: rgba(0, 224, 255, .08);
            border: 1px solid var(--border-2);
            color: #cfe7ff;
            border-radius: 999px;
            padding: .25rem .6rem;
            font-weight: 600;
        }

        /* ====== Donut ====== */
        .donut {
            transform: rotate(-90deg);
        }

        .donut-base {
            stroke: #1e2a3c;
        }

        .donut-prog {
            stroke: url(#g);
            transition: stroke-dasharray .6s ease-in-out;
        }

        .chart-center {
            position: absolute;
            inset: 0;
            display: grid;
            place-items: center;
        }

        .chart-percentage {
            font-size: .75rem;
            font-weight: 700;
            color: var(--neon-2);
        }

        /* Grid */
        .g {
            display: grid;
            gap: 1rem;
        }

        @media(min-width:992px) {
            .g-3 {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        .neon-btn:focus {
            outline: none;
            box-shadow: 0 0 0 2px rgba(0, 224, 255, .35);
        }

        .flt-select:focus,
        .flt-date:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
        }
    </style>
@endpush

@section('content')
    <div class="container-fluid py-3">
        <div class="card-n mb-3">
            <div
                class="card-body d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center">
                <div class="mb-3 mb-lg-0">
                    <h3 class="neon-title mb-1">Team Attendance Overview</h3>
                    <p class="sub-muted small mb-0">Monitor and track your team's attendance</p>
                    <p class="mt-2 mb-0 small">
                        Period:
                        <span class="neon-chip">{{ $startDate->format('M d, Y') }}</span>
                        —
                        <span class="neon-chip">{{ $endDate->format('M d, Y') }}</span>
                    </p>
                </div>

                {{-- 🧭 Filters --}}
                <form method="GET" action="{{ url()->current() }}" class="flt-wrap">
                    <select name="filter" id="filter" class="flt-select" onchange="toggleCustomDates()">
                        <option value="day" {{ $filter == 'day' ? 'selected' : '' }}>Today</option>
                        <option value="week" {{ $filter == 'week' ? 'selected' : '' }}>This Week</option>
                        <option value="month" {{ $filter == 'month' ? 'selected' : '' }}>This Month</option>
                        <option value="custom"{{ $filter == 'custom' ? 'selected' : '' }}>Custom Range</option>
                    </select>

                    <div id="customDates" class="d-flex"
                        style="display: {{ $filter == 'custom' ? 'flex' : 'none' }} !important; gap:.6rem;">
                        <input type="date" name="custom_start" id="custom_start" class="flt-date"
                            value="{{ request('custom_start') }}" placeholder="Start Date" title="Start Date">
                        <input type="date" name="custom_end" id="custom_end" class="flt-date"
                            value="{{ request('custom_end') }}" placeholder="End Date" title="End Date">
                    </div>

                    <button type="submit" class="neon-btn">
                        <i class="fas fa-filter mr-1"></i> Apply Filter
                    </button>
                </form>
            </div>
        </div>

        {{-- 🧩 Departments --}}
        @if (isset($errorMessage))
            <div class="alert alert-warning">{{ $errorMessage }}</div>
        @else
            @if (count($departmentStats))
                <div class="g g-3">
                    @foreach ($departmentStats as $dept)
                        <div class="dept-card">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="mr-3">
                                    <h6 class="dept-name mb-2">
                                        <i class="fas fa-users mr-2"></i>{{ $dept['name'] }}
                                    </h6>

                                    <div class="attendance-percentage mb-2">
                                        <span class="h4 font-weight-bold">{{ $dept['attendance_rate'] }}%</span>
                                        <small class="sub-muted ml-1">Attendance</small>
                                    </div>

                                    <span class="present-badge">
                                        {{ $dept['attended_employees'] }}/{{ $dept['total_employees'] }} Present
                                    </span>
                                </div>

                                {{-- Donut --}}
                                <div class="position-relative" style="width:72px;height:72px">
                                    <svg width="72" height="72" viewBox="0 0 42 42" class="donut">
                                        <defs>
                                            <linearGradient id="g" x1="0%" y1="0%" x2="100%"
                                                y2="100%">
                                                <stop offset="0%" stop-color="#00e0ff" />
                                                <stop offset="100%" stop-color="#ff5fff" />
                                            </linearGradient>
                                        </defs>
                                        <circle cx="21" cy="21" r="15.915" fill="transparent" stroke-width="2"
                                            class="donut-base"></circle>
                                        <circle cx="21" cy="21" r="15.915" fill="transparent" stroke-width="2"
                                            class="donut-prog" stroke-dasharray="{{ $dept['attendance_rate'] }},100"
                                            stroke-dashoffset="25"></circle>
                                    </svg>
                                    <div class="chart-center">
                                        <small class="chart-percentage">{{ $dept['attendance_rate'] }}%</small>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <a href="{{ route('team-lead.department.employees', ['departmentId' => $dept['id'], 'filter' => $filter, 'custom_start' => request('custom_start'), 'custom_end' => request('custom_end')]) }}"
                                    class="neon-btn d-inline-flex align-items-center justify-content-center mr-2 flex-fill">
                                    <i class="fas fa-eye mr-2"></i> View Details
                                </a>

                                <a href="{{ route('team-lead.department.export', ['departmentId' => $dept['id'], 'filter' => $filter, 'custom_start' => request('custom_start'), 'custom_end' => request('custom_end')]) }}"
                                    class="neon-btn neon-btn-success d-inline-flex align-items-center justify-content-center flex-fill"
                                    title="Export to Excel">
                                    <i class="fas fa-file-excel mr-2"></i> Export
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="card-n">
                    <div class="card-body text-center">
                        <p class="sub-muted mb-0">No team members found in your managed departments.</p>
                    </div>
                </div>
            @endif
        @endif
    </div>

    <script>
        function toggleCustomDates() {
            const filter = document.getElementById('filter').value;
            const box = document.getElementById('customDates');
            box.style.display = (filter === 'custom') ? 'flex' : 'none';
        }

        // Toasts سريعة عند تطبيق الفلتر (Optional حلوة في الـ UX)
        document.querySelector('form.flt-wrap')?.addEventListener('submit', function() {
            window.toast?.info('Filter Applied', 'Reloading overview…', 1200);
        });
    </script>
@endsection
