@extends('layout.default')

@section('title', 'Department Employees - ' . $department->name)

{{-- Neon tokens + Toasts --}}
@includeIf('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
    <style>
        /* ===== Tokens (fallbacks لو متغيّرات الثيم ناقصة) ===== */
        :root {
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        body {
            background: var(--body-bg);
            color: var(--text-main);
        }

        /* ===== Shell ===== */
        .card-n {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .95), rgba(8, 12, 24, .95)); */
        }

        .card-n .card-header {
            border-bottom: 1px solid var(--border);
            padding: 14px 16px;
        }

        .card-n .card-body {
            padding: 16px;
        }

        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }

        .sub-muted {
            color: var(--muted);
        }

        /* ===== Filters ===== */
        .flt-wrap {
            display: flex;
            gap: .6rem;
            flex-wrap: wrap;
            align-items: center;
        }

        .flt-select,
        .flt-date {
            /* background: #0e1326; */
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .5rem .7rem;
            min-width: 160px;
            outline: none;
            transition: border-color .15s, box-shadow .15s;
        }

        .flt-select:focus,
        .flt-date:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
        }

        .neon-btn {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            padding: .55rem 1rem;
            border-radius: 10px;
            display: inline-flex;
            align-items: center;
            gap: .45rem;
            transition: transform .18s, box-shadow .18s;
            box-shadow: var(--glow);
            text-decoration: none !important;
        }

        .neon-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .neon-btn:focus {
            outline: none;
            box-shadow: 0 0 0 2px rgba(0, 224, 255, .35);
        }

        /* ===== Table ===== */
        .tbl-wrap {
            border: 1px solid var(--border);
            border-radius: 12px;
            overflow: hidden;
        }

        table.table-neon {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            color: #dce7ff;
        }

        .table-neon thead th {
            background: rgba(0, 224, 255, .10);
            color: #cfe7ff;
            border-bottom: 1px solid var(--border-2);
            padding: 12px 14px;
            text-shadow: 0 0 8px rgba(0, 224, 255, .25);
        }

        .table-neon tbody td {
            padding: 12px 14px;
            border-bottom: 1px solid rgba(0, 224, 255, .08);
            vertical-align: middle;
        }

        .table-neon tbody tr:hover {
            background: rgba(0, 224, 255, .04);
        }

        /* ===== Progress (Attendance Rate) ===== */
        .bar {
            position: relative;
            width: 140px;
            height: 14px;
            border-radius: 999px;
            background: #122035;
            border: 1px solid var(--border);
            overflow: hidden;
        }

        .bar__fill {
            position: absolute;
            inset: 0;
            width: 0;
        }

        .bar__fill--good {
            background: linear-gradient(90deg, rgba(42, 252, 152, .55), rgba(0, 224, 255, .40));
        }

        .bar__fill--avg {
            background: linear-gradient(90deg, rgba(255, 185, 0, .55), rgba(255, 127, 39, .35));
        }

        .bar__fill--bad {
            background: linear-gradient(90deg, rgba(255, 95, 95, .55), rgba(255, 0, 130, .30));
        }

        /* ===== Badges ===== */
        .badge-n {
            display: inline-block;
            padding: .28rem .55rem;
            border-radius: 10px;
            font-weight: 700;
            font-size: .75rem;
            border: 1px solid transparent;
        }

        .b-success {
            background: linear-gradient(90deg, rgba(42, 252, 152, .25), rgba(0, 224, 255, .18));
            color: #dfffea;
            border-color: rgba(42, 252, 152, .45);
        }

        .b-warning {
            background: linear-gradient(90deg, rgba(255, 185, 0, .27), rgba(255, 127, 39, .20));
            color: #fff0c9;
            border-color: rgba(255, 185, 0, .45);
        }

        .b-danger {
            background: linear-gradient(90deg, rgba(255, 95, 95, .26), rgba(255, 0, 130, .18));
            color: #ffe6ea;
            border-color: rgba(255, 95, 95, .45);
        }

        .muted {
            color: #8aa0c4;
        }

        @media (max-width: 767px) {
            .flt-wrap {
                gap: .5rem;
            }

            .tbl-wrap {
                overflow-x: auto;
            }
        }
    </style>
@endpush


@section('content')
    <div class="container-fluid">
        <div class="card-n">
            <div class="card-header">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center">
                    <div class="mb-3 mb-lg-0">
                        <h3 class="neon-title">{{ $department->name }} - Employee Attendance</h3>
                        <p class="sub-muted small mb-0">Monitor individual employee attendance and performance</p>
                        <p class="mt-2 mb-0 small">
                            Period:
                            <span class="badge-n b-info">{{ $startDate->format('M d, Y') }}</span>
                            —
                            <span class="badge-n b-info">{{ $endDate->format('M d, Y') }}</span>
                        </p>
                    </div>

                    {{-- Filters --}}
                    <form method="GET" action="{{ url()->current() }}" class="flt-wrap">
                        <select name="filter" id="filter" class="flt-select" onchange="toggleCustomDates()">
                            <option value="day" {{ $filter == 'day' ? 'selected' : '' }}>Today</option>
                            <option value="week" {{ $filter == 'week' ? 'selected' : '' }}>This Week</option>
                            <option value="month" {{ $filter == 'month' ? 'selected' : '' }}>This Month</option>
                            <option value="custom"{{ $filter == 'custom' ? 'selected' : '' }}>Custom Range</option>
                        </select>

                        <div id="customDates" class="d-flex"
                            style="display: {{ $filter == 'custom' ? 'flex' : 'none' }} !important; gap:.6rem;">
                            <input type="date" name="custom_start" id="custom_start" class="flt-date"
                                value="{{ request('custom_start') }}" placeholder="Start Date" title="Start Date">
                            <input type="date" name="custom_end" id="custom_end" class="flt-date"
                                value="{{ request('custom_end') }}" placeholder="End Date" title="End Date">
                        </div>

                        <button type="submit" class="neon-btn">
                            <i class="fas fa-filter"></i><span>Apply Filter</span>
                        </button>
                    </form>
                </div>
            </div>

            <div class="card-body">
                <div class="tbl-wrap">
                    <table class="table-neon">
                        <thead>
                            <tr>
                                <th>Employee Name</th>
                                <th>Attendance Rate</th>
                                <th>Days Attended</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($employees as $employee)
                                @php
                                    $rate = (int) ($employee['attendance_rate'] ?? 0);
                                    $cls =
                                        $rate >= 80
                                            ? 'bar__fill--good'
                                            : ($rate >= 60
                                                ? 'bar__fill--avg'
                                                : 'bar__fill--bad');
                                    $stat =
                                        $rate >= 80
                                            ? ['b-success', 'Excellent']
                                            : ($rate >= 60
                                                ? ['b-warning', 'Average']
                                                : ['b-danger', 'Poor']);
                                @endphp
                                <tr>
                                    <td>
                                        <strong>{{ $employee['name'] }}</strong><br>
                                        <small class="muted">{{ $employee['employee_code'] ?? 'N/A' }}</small>
                                    </td>

                                    <td>
                                        <div class="d-flex align-items-center" style="gap:.6rem">
                                            <div class="bar">
                                                <div class="bar__fill {{ $cls }}"
                                                    style="width: {{ $rate }}%"></div>
                                            </div>
                                            <span class="fw-bold">{{ $rate }}%</span>
                                        </div>
                                    </td>

                                    <td><span class="badge-n b-info">{{ $employee['attended_days'] }}</span></td>

                                    <td><span class="badge-n {{ $stat[0] }}">{{ $stat[1] }}</span></td>

                                    <td>
                                        <div class="d-flex" style="gap:.5rem">
                                            <a href="{{ route('team-lead.employee.performance', ['employeeId' => $employee['id'], 'filter' => $filter, 'custom_start' => request('custom_start'), 'custom_end' => request('custom_end')]) }}"
                                                class="neon-btn btn-sm"><i class="fas fa-eye"></i><span>View</span></a>
                                            <a href="{{ route('team-lead.employee.export', ['employeeId' => $employee['id'], 'filter' => $filter, 'custom_start' => request('custom_start'), 'custom_end' => request('custom_end')]) }}"
                                                class="neon-btn btn-sm" title="Export attendance data with current filters">
                                                <i class="fas fa-download"></i><span>Export</span></a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @if (count($employees) == 0)
                    <div class="text-center py-4">
                        <p class="sub-muted mb-0">No employees found in this department.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        function toggleCustomDates() {
            const v = document.getElementById('filter')?.value;
            const box = document.getElementById('customDates');
            if (!box) return;
            box.style.display = (v === 'custom') ? 'flex' : 'none';
        }

        // Toast خفيف عند تطبيق الفلتر
        document.querySelector('form.flt-wrap')?.addEventListener('submit', function() {
            window.toast?.info('Filter Applied', 'Reloading records…', 1200);
        });
    </script>
@endpush
