@extends('layout.default')

@section('title', 'Employee Performance - Team Lead')

{{-- هوية النيّون + التوست --}}
@includeIf('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
    <style>
        /* ===== Tokens (fallbacks لو ناقصة من الثيم) ===== */
        :root {
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        body {
            background: var(--body-bg);
            color: var(--text-main);
        }

        /* ===== Shell ===== */
        .card-n {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);

        }

        .card-n .card-header {
            border-bottom: 1px solid var(--border);
            padding: 14px 16px;
        }

        .card-n .card-body {
            padding: 16px;
        }

        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }

        .sub-muted {
            color: var(--muted);
        }

        /* ===== Filters ===== */
        .flt-wrap {
            display: flex;
            gap: .6rem;
            flex-wrap: wrap;
            align-items: center;
        }

        .flt-select,
        .flt-date {
            background: #0e1326;
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .5rem .7rem;
            min-width: 160px;
            outline: none;
        }

        .flt-select:focus,
        .flt-date:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
        }

        .neon-btn {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            padding: .55rem 1rem;
            border-radius: 10px;
            display: inline-flex;
            align-items: center;
            gap: .45rem;
            transition: transform .18s, box-shadow .18s;
            box-shadow: var(--glow);
            text-decoration: none !important;
        }

        .neon-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .neon-btn:focus {
            outline: none;
            box-shadow: 0 0 0 2px rgba(0, 224, 255, .35);
        }

        /* ===== KPI Tiles ===== */
        .kpi {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            height: 100%;
            background: linear-gradient(90deg, rgba(97, 120, 255, .18), rgba(255, 95, 255, .18));
        }

        .kpi .h4 {
            margin: 0;
            font-weight: 800;
        }

        .kpi .icon {
            opacity: .9;
        }

        /* بلاطات مخصوصة */
        .kpi--hours {
            background: linear-gradient(90deg, rgba(255, 90, 120, .25), rgba(255, 95, 255, .18));
        }

        .kpi--time {
            background: linear-gradient(90deg, rgba(0, 224, 255, .14), rgba(0, 224, 255, .10));
        }

        /* ===== Table ===== */
        .tbl-wrap {
            border: 1px solid var(--border);
            border-radius: 12px;
            overflow: hidden;
        }

        table.table-neon {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            color: #dce7ff;
        }

        .table-neon thead th {
            background: rgba(0, 224, 255, .10);
            color: #cfe7ff;
            border-bottom: 1px solid var(--border-2);
            padding: 12px 14px;
            text-shadow: 0 0 8px rgba(0, 224, 255, .25);
        }

        .table-neon tbody td {
            padding: 12px 14px;
            border-bottom: 1px solid rgba(0, 224, 255, .08);
            vertical-align: middle;
        }

        .table-neon tbody tr:hover {
            background: rgba(0, 224, 255, .04);
        }

        /* ===== Badges ===== */
        .badge-n {
            display: inline-block;
            padding: .3rem .6rem;
            border-radius: 10px;
            font-weight: 700;
            font-size: .75rem;
            border: 1px solid transparent;
        }

        .b-success {
            background: linear-gradient(90deg, rgba(42, 252, 152, .25), rgba(0, 224, 255, .18));
            color: #dfffea;
            border-color: rgba(42, 252, 152, .45);
        }

        .b-info {
            background: linear-gradient(90deg, rgba(0, 224, 255, .25), rgba(255, 95, 255, .18));
            color: #e7fbff;
            border-color: rgba(0, 224, 255, .45);
        }

        .b-warn {
            background: linear-gradient(90deg, rgba(255, 185, 0, .27), rgba(255, 127, 39, .20));
            color: #fff0c9;
            border-color: rgba(255, 185, 0, .45);
        }

        .b-muted {
            background: rgba(255, 255, 255, .08);
            color: #b8c6e6;
            border-color: rgba(255, 255, 255, .15);
        }

        .muted {
            color: #8aa0c4;
        }

        @media (max-width: 767px) {
            .tbl-wrap {
                overflow-x: auto;
            }

            .card-n .card-body {
                padding: 12px;
            }
        }
    </style>
@endpush


@section('content')
    <div class="container-fluid">
        <div class="card-n">
            <div class="card-header">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center">
                    <div class="mb-3 mb-lg-0">
                        <h3 class="neon-title"><i class="fas fa-user mr-2"></i> {{ $employee->full_name }}</h3>
                        <p class="sub-muted small mb-0">Employee performance and attendance tracking</p>
                    </div>

                    {{-- Filters + Export --}}
                    <div class="d-flex flex-column flex-md-row align-items-md-center" style="gap:.6rem;">
                        <form method="GET" action="{{ url()->current() }}" class="flt-wrap">
                            <select name="filter" id="filter" class="flt-select" onchange="toggleCustomDates()">
                                <option value="day" {{ $filter == 'day' ? 'selected' : '' }}>Today</option>
                                <option value="week" {{ $filter == 'week' ? 'selected' : '' }}>This Week</option>
                                <option value="month" {{ $filter == 'month' ? 'selected' : '' }}>This Month</option>
                                <option value="custom"{{ $filter == 'custom' ? 'selected' : '' }}>Custom Range</option>
                            </select>

                            <div id="customDates" class="d-flex"
                                style="display: {{ $filter == 'custom' ? 'flex' : 'none' }} !important; gap:.6rem;">
                                <input type="date" name="custom_start" id="custom_start" class="flt-date"
                                    value="{{ request('custom_start') }}" placeholder="Start Date" title="Start Date">
                                <input type="date" name="custom_end" id="custom_end" class="flt-date"
                                    value="{{ request('custom_end') }}" placeholder="End Date" title="End Date">
                            </div>


                        </form>
                        <button type="submit" class="neon-btn"><i class="fas fa-filter"></i> Apply Filter</button>

                        <a href="{{ route('team-lead.employee.export', ['employeeId' => $employee->id, 'filter' => $filter ?? 'month', 'custom_start' => request('custom_start'), 'custom_end' => request('custom_end')]) }}"
                            class="neon-btn"><i class="fas fa-download"></i> Export</a>
                    </div>
                </div>
            </div>

            <div class="card-body">
                {{-- Period --}}
                <p class="small sub-muted mb-3">
                    Period:
                    <span class="badge-n b-info">{{ $startDate->format('M d, Y') }}</span>
                    —
                    <span class="badge-n b-info">{{ $endDate->format('M d, Y') }}</span>
                </p>

                {{-- KPI Tiles --}}
                <div class="row mb-3">
                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi p-3 d-flex justify-content-between align-items-center">
                            <div>
                                <div class="h4">{{ $attendanceRate }}%</div>
                                <div class="small sub-muted">Attendance Rate</div>
                            </div>
                            <i class="fas fa-percentage fa-lg icon"></i>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi p-3 d-flex justify-content-between align-items-center">
                            <div>
                                <div class="h4">{{ $attendedDays }}</div>
                                <div class="small sub-muted">Days Attended</div>
                            </div>
                            <i class="fas fa-calendar-check fa-lg icon"></i>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi p-3 d-flex justify-content-between align-items-center">
                            <div>
                                <div class="h4">{{ $totalWorkDays }}</div>
                                <div class="small sub-muted">Total Work Days</div>
                            </div>
                            <i class="fas fa-calendar fa-lg icon"></i>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6 mb-3">
                        <div class="kpi kpi--hours p-3 d-flex justify-content-between align-items-center">
                            <div>
                                <div class="h4">{{ $avgWorkHours ?? 'N/A' }}{{ $avgWorkHours ? 'h' : '' }}</div>
                                <div class="small sub-muted">Avg Work Hours</div>
                            </div>
                            <i class="fas fa-clock fa-lg icon"></i>
                        </div>
                    </div>

                    @if ($avgCheckInTime)
                        <div class="col-md-3 col-sm-6 mb-3">
                            <div class="kpi kpi--time p-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="h4">{{ $avgCheckInTime }}</div>
                                    <div class="small sub-muted">Avg Check-in Time</div>
                                </div>
                                <i class="fas fa-sign-in-alt fa-lg icon"></i>
                            </div>
                        </div>
                    @endif
                </div>

                {{-- Attendance Records --}}
                <div class="card-n">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-list mr-2"></i>
                            <span class="neon-title" style="font-size:1.05rem; display:inline-block; margin:0;">Attendance
                                Records</span>
                            <small class="sub-muted">({{ $startDate->format('M d') }} -
                                {{ $endDate->format('M d, Y') }})</small>
                        </h5>
                    </div>
                    <div class="card-body">
                        @if ($dailyAttendance->count() > 0)
                            <div class="tbl-wrap">
                                <table class="table-neon">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Check In</th>
                                            <th>Check Out</th>
                                            <th>Working Hours</th>
                                            <th>Records</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($dailyAttendance as $record)
                                            <tr>
                                                <td>
                                                    <strong>{{ \Carbon\Carbon::parse($record['date'])->format('M d, Y') }}</strong><br>
                                                    <small
                                                        class="muted">{{ \Carbon\Carbon::parse($record['date'])->format('l') }}</small>
                                                </td>
                                                <td>
                                                    @if ($record['check_in'])
                                                        <span class="badge-n b-success"><i
                                                                class="fas fa-sign-in-alt mr-1"></i>{{ $record['check_in'] }}</span>
                                                    @else
                                                        <span class="badge-n b-muted"><i class="fas fa-minus mr-1"></i>No
                                                            Check-in</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($record['check_out'])
                                                        <span class="badge-n b-info"><i
                                                                class="fas fa-sign-out-alt mr-1"></i>{{ $record['check_out'] }}</span>
                                                    @else
                                                        <span class="badge-n b-warn"><i class="fas fa-minus mr-1"></i>No
                                                            Check-out</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($record['working_hours'])
                                                        <span class="badge-n b-info"><i
                                                                class="fas fa-clock mr-1"></i>{{ number_format($record['working_hours'], 1) }}h</span>
                                                    @else
                                                        <span class="badge-n b-muted"><i
                                                                class="fas fa-minus mr-1"></i>N/A</span>
                                                    @endif
                                                </td>
                                                <td class="muted small">
                                                    {{ $record['check_ins'] }} in, {{ $record['check_outs'] }} out<br>
                                                    ({{ $record['total_records'] }} total)
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i class="fas fa-calendar-times fa-3x muted mb-3"></i>
                                <h6 class="muted">No attendance records found</h6>
                                <p class="muted mb-0">{{ $employee->full_name }} has no attendance records in the selected
                                    period.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        function toggleCustomDates() {
            const filter = document.getElementById('filter')?.value;
            const box = document.getElementById('customDates');
            if (!box) return;
            box.style.display = (filter === 'custom') ? 'flex' : 'none';
        }

        // Toast بسيط عند تطبيق الفلتر
        document.querySelector('form.flt-wrap')?.addEventListener('submit', function() {
            window.toast?.info('Filter Applied', 'Reloading records…', 1200);
        });
    </script>
@endpush
