@extends('layout.default')
@section('title','تعديل طلب إجازة')

@include('partial.theme.neon-vars')
@include('pages.vacations.partial.ui')
@include('partial.toast-js')

@section('content')
<div class="container-fluid">
  <div class="card card-border">
    {{-- Header --}}
    <div class="card-header d-flex align-items-center justify-content-between">
      <div class="d-flex align-items-center gap-2">
        <a href="{{ route('vacations.show', $vacation) }}" class="btn btn-outline-inverse btn-sm">← رجوع</a>
        <h5 class="mb-0 text-inverse">تعديل الطلب #{{ $vacation->id }}</h5>
      </div>
      <a href="#" class="btn btn-outline-inverse btn-sm" data-toggle="card-expand">تكبير</a>
    </div>

    {{-- Body --}}
    <div class="card-body">
      <form id="vacationEditForm" method="POST" action="{{ route('vacations.update', $vacation) }}" class="hud-form">
        @method('PUT')
        @include('pages.vacations.partial.form', [
          'vacation'   => $vacation,
          'types'      => $types,
          'submitText' => 'تحديث'
        ])
      </form>
    </div>
  </div>
</div>
@endsection

@push('js')
<script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('vacationEditForm');
  if (!form) return;

  form.addEventListener('submit', async (e) => {
    e.preventDefault();

    const url = form.action;
    const formData = new FormData(form);
    const payload = {};
    formData.forEach((val, key) => payload[key] = val);

    try {
      const res = await fetch(url, {
        method: 'POST', // لازم POST مع @method('PUT')
        headers: {
          'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.content || '',
          'Accept': 'application/json',
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(payload)
      });

      if (!res.ok) {
        return window.toast.fromResponse(res, 'خطأ');
      }

      const data = await res.json();

      if (data?.toast && data.toast.variant && window.toast[data.toast.variant]) {
        window.toast[data.toast.variant](data.toast.title || 'تم', data.toast.body || data.message || '');
      } else {
        window.toast.success('تم', data?.message || 'تم تحديث الطلب بنجاح');
      }

      if (data?.id) {
        // تحويل لصفحة show بعد ثانية صغيرة
        setTimeout(() => {
          window.location.href = `{{ url('dashboard/attendance/vacations') }}/${data.id}`;
        }, 1000);
      }
    } catch (err) {
      window.toast.error('خطأ', err?.message || 'حدث خطأ غير متوقع');
    }
  });
});
</script>
@endpush
