@extends('layout.default')
@section('title', 'طلبات الإجازات')

{{-- نفس متغيّرات النيون + شريحة UI + نظام التوست --}}
@include('partial.theme.neon-vars')
@include('pages.vacations.partial.ui')
@include('partial.toast-js')

@push('css')
    <style>
        /* ===== Tokens (fallbacks فقط لو ناقصة من الثيم) ===== */
        :root {
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        body {
            background: var(--body-bg);
            color: var(--text-main);
        }

        /* ===== Card ===== */
        .card-border {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .95), rgba(8, 12, 24, .95)); */
        }

        .card-header {
            border-bottom: 1px solid var(--border);
            padding: 12px 16px;
        }

        .card-body {
            padding: 16px;
        }

        /* ===== Heading ===== */
        .text-inverse {
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
            margin: 0;
            font-weight: 800;
        }

        /* ===== Buttons HUD ===== */
        .btn-inverse,
        .btn-outline-inverse,
        .btn-theme,
        .btn-success.btn-xs,
        .btn-danger.btn-xs {
            border-radius: 10px;
            transition: .18s ease;
            box-shadow: var(--glow);
        }

        .btn-inverse {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            border: 1px solid var(--border-2);
            color: #e9f6ff;
            padding: .45rem .8rem;
        }

        .btn-outline-inverse {
            background: transparent;
            color: #e9f6ff;
            border: 1px solid var(--border);
            padding: .45rem .8rem;
        }

        .btn-theme {
            background: transparent;
            color: #e9f6ff;
            border: 1px solid var(--border);
        }

        .btn-inverse:hover,
        .btn-outline-inverse:hover,
        .btn-theme:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .btn:focus {
            outline: none !important;
            box-shadow: 0 0 0 2px rgba(0, 224, 255, .35) !important;
        }

        /* ===== Filters container (partial.filters) ===== */
        .filters-wrap .form-control {
            background: #0e1326;
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .5rem .65rem;
        }

        .filters-wrap .form-control:focus {
            border-color: var(--border-2);
            box-shadow: var(--ring);
        }

        /* ===== DataTable HUD ===== */
        .dataTables_wrapper .dt-buttons .btn {
            @apply none;
            /* للسلامة؛ نتجاهل Tailwind إن وُجد */
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            border-radius: 10px;
            margin: 0 .25rem .5rem 0;
            padding: .4rem .8rem;
            box-shadow: var(--glow);
        }

        .dataTables_wrapper .dataTables_length select,
        .dataTables_wrapper .dataTables_filter input {
            background: #0e1326;
            color: #e3eeff;
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: .4rem .6rem;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:focus,
        .dataTables_wrapper .dataTables_length select:focus {
            box-shadow: var(--ring);
            border-color: var(--border-2);
        }

        table.dataTable {
            color: #dce7ff;
            border-collapse: separate;
            border-spacing: 0;
        }

        table.dataTable thead th {
            background: rgba(0, 224, 255, .10);
            color: #cfe7ff;
            border-bottom: 1px solid var(--border-2);
            text-shadow: 0 0 8px rgba(0, 224, 255, .25);
        }

        table.dataTable tbody td {
            border-color: rgba(0, 224, 255, .08);
        }

        table.dataTable tbody tr:hover {
            background: rgba(0, 224, 255, .04);
        }

        /* Pagination */
        .pagination .page-link {
            background: #0e1326;
            color: #cfe7ff;
            border: 1px solid var(--border);
        }

        .pagination .page-item.active .page-link {
            background: linear-gradient(90deg, rgba(0, 224, 255, .22), rgba(255, 95, 255, .18));
            border-color: var(--border-2);
            color: #fff;
            box-shadow: var(--glow);
        }

        /* Badges من partial.ui (هنا بس تحسين محيطي لو ناقص) */
        .badge-hud {
            border-radius: 10px;
            padding: .25rem .6rem;
            font-weight: 700;
            font-size: .75rem;
        }

        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }
    </style>
@endpush


@section('content')
    <div class="container-fluid">
        <div class="card card-border">
            {{-- ===== Header ===== --}}
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0 neon-title">طلبات الإجازات</h5>

                <div class="d-flex align-items-center gap-2">
                    <a href="{{ route('vacations.create') }}" class="btn btn-inverse btn-sm">طلب إجازة</a>
                    <a href="#" class="btn btn-outline-inverse btn-theme" data-toggle="card-expand">تكبير</a>
                </div>
            </div>

            {{-- ===== Filters + Table ===== --}}
            <div class="card-body">
                {{-- أصول الداتا تيبلز (مرة واحدة) --}}
                @include('partial.datatable.assets')

                {{-- فلاتر موحّدة --}}
                <div class="filters-wrap">
                    @include('pages.vacations.partial.filters')
                </div>

                {{-- جدول موحّد --}}
                @include('partial.datatable.init', [
                    'id' => 'vacationsTable',
                    'ajax' => route('vacations.dt'),
                    'columns' => [
                        ['data' => 'id'],
                        ['data' => 'employee_name'],
                        ['data' => 'type_name'],
                        ['data' => 'start_date'],
                        ['data' => 'end_date'],
                        ['data' => 'total_days'],
                        ['data' => null, 'orderable' => false, 'searchable' => false, 'render' => 'vac_status'],
                        ['data' => null, 'orderable' => false, 'searchable' => false, 'render' => 'vac_actions'],
                    ],
                    'order' => [[0, 'desc']],
                    'exportColumns' => [0, 1, 2, 3, 4, 5, 6],
                    'responsive' => 'inline',
                    'filtersHook' => 'vacFilters',
                    'thead' => view('pages.vacations.partial.thead'),
                ])
            </div>
        </div>
    </div>
@endsection


@push('js')
    <script>
        // ---- 1) Hook الفلاتر للـ Ajax
        window.vacFilters = function() {
            return {
                type: document.getElementById('fltType')?.value || '',
                status: document.getElementById('fltStatus')?.value || '',
                search: document.getElementById('fltSearch')?.value || ''
            };
        };

        // ---- 2) Renderers
        window.DT = window.DT || {};
        DT.renderers = DT.renderers || {};

        DT.renderers.vac_status = function(_, row) {
            const status = (row.status_value || row.status || 'pending');
            const map = {
                pending: {
                    cls: 'badge-hud badge-hud--pending',
                    text: 'قيد الانتظار'
                },
                leader_approved: {
                    cls: 'badge-hud badge-hud--leader',
                    text: 'موافقة TL'
                },
                hr_approved: {
                    cls: 'badge-hud badge-hud--hr',
                    text: 'موافقة HR'
                },
                rejected: {
                    cls: 'badge-hud badge-hud--rejected',
                    text: 'مرفوض'
                }
            };
            const cfg = map[status] || map.pending;
            return `<span class="${cfg.cls}" title="${status}">${cfg.text}</span>`;
        };

        DT.renderers.vac_actions = function(_, row) {
            const base = `{{ url('/dashboard/attendance/vacations') }}/${row.id}`;
            const canEdit = !!row.can_update;
            const canLeaderApprove = !!row.can_leader_approve;
            const canHrApprove = !!row.can_hr_approve;
            const canReject = !!row.can_reject;

            const btnShow = `<a href="${base}" class="btn btn-inverse btn-xs">عرض</a>`;
            const btnEdit = canEdit ? `<a href="${base}/edit" class="btn btn-outline-inverse btn-xs">تعديل</a>` : '';
            const tlBtn = canLeaderApprove ?
                `<button class="btn btn-success btn-xs" data-action="leader-approve" data-id="${row.id}">اعتماد TL</button>` :
                '';
            const hrBtn = canHrApprove ?
                `<button class="btn btn-success btn-xs" data-action="hr-approve"     data-id="${row.id}">اعتماد HR</button>` :
                '';
            const rejBtn = canReject ?
                `<button class="btn btn-danger  btn-xs" data-action="reject"         data-id="${row.id}">رفض</button>` :
                '';

            const rightSide = [btnEdit, btnShow, tlBtn, hrBtn, rejBtn].filter(Boolean).join(' ');
            return `<div class=""><div class="">${rightSide || '<span class="text-muted">—</span>'}</div></div>`;
        };

        // اربط الأسماء
        window.DT.renderers.vac_status = DT.renderers.vac_status;
        window.DT.renderers.vac_actions = DT.renderers.vac_actions;

        // ---- 3) سلوك البحث / الريسِت
        (function() {
            const reload = () => window.DT_INSTANCES?.['vacationsTable']?.ajax?.reload(null, false);
            let st;
            document.getElementById('fltSearch')?.addEventListener('input', () => {
                clearTimeout(st);
                st = setTimeout(reload, 300);
            });
            ['fltType', 'fltStatus'].forEach(id => {
                document.getElementById(id)?.addEventListener('change', reload);
            });
            document.getElementById('btnReset')?.addEventListener('click', () => {
                const s = document.getElementById('fltSearch');
                if (s) s.value = '';
                const t = document.getElementById('fltType');
                if (t) t.value = '';
                const stt = document.getElementById('fltStatus');
                if (stt) stt.value = '';
                reload();
            });
        })();

        // ---- 4) أزرار الاعتمادات / الرفض مع Toasts + منع الدبل-كلك
        document.addEventListener('click', async (e) => {
            const btn = e.target.closest('[data-action][data-id]');
            if (!btn) return;
            if (btn.dataset.busy === '1') return;
            btn.dataset.busy = '1';
            btn.disabled = true;

            const id = btn.dataset.id;
            const action = btn.dataset.action; // leader-approve | hr-approve | reject
            const base = `{{ url('dashboard/attendance/vacations') }}/${id}`;

            const url = action === 'leader-approve' ?
                `${base}/leader-approve` :
                action === 'hr-approve' ?
                `${base}/hr-approve` :
                `${base}/reject`;

            let reason = '';
            const prompts = {
                'leader-approve': 'اعتماد التيم ليدر\n\nسبب (اختياري):',
                'hr-approve': 'اعتماد HR\n\nسبب (اختياري):',
                'reject': 'رفض الطلب\n\nسبب (اختياري):'
            };
            const r = prompt(prompts[action] || '', '');
            if (r === null) {
                btn.dataset.busy = '0';
                btn.disabled = false;
                return;
            }
            reason = r || null;

            try {
                const res = await fetch(url, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.content || '',
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        reason
                    })
                });

                if (!res.ok) return window.toast.fromResponse(res, 'خطأ');

                const data = await res.json().catch(() => ({}));
                if (data?.toast?.variant && typeof window.toast[data.toast.variant] === 'function') {
                    window.toast[data.toast.variant](data.toast.title || 'تم', data.toast.body || data
                        .message || '');
                } else {
                    window.toast.success('تم', data?.message || 'نُفِّذ الطلب بنجاح');
                }
                window.DT_INSTANCES?.['vacationsTable']?.ajax?.reload(null, false);
            } catch (err) {
                window.toast.error('خطأ', err?.message || 'حدث خطأ غير متوقع');
            } finally {
                btn.dataset.busy = '0';
                btn.disabled = false;
            }
        });
    </script>
@endpush
