@csrf

@php
  $v = $vacation;
@endphp

<div class="row g-3">
  {{-- نوع الإجازة --}}
  <div class="col-12 col-md-4">
    <label class="form-label text-inverse small mb-1">نوع الإجازة</label>
    <select name="vacation_type_id" class="form-select">
      <option value="">اختر النوع</option>
      @foreach($types as $t)
        <option value="{{ $t->id }}" @selected(old('vacation_type_id', $v->vacation_type_id ?? '') == $t->id)>
          {{ $t->name }}
        </option>
      @endforeach
    </select>
    @error('vacation_type_id') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
  </div>

  {{-- من تاريخ --}}
  <div class="col-6 col-md-4">
    <label class="form-label text-inverse small mb-1">من تاريخ</label>
    <input type="date" name="start_date" class="form-control"
           value="{{ old('start_date', optional($v->start_date ?? null)->format('Y-m-d')) }}">
    @error('start_date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
  </div>

  {{-- إلى تاريخ --}}
  <div class="col-6 col-md-4">
    <label class="form-label text-inverse small mb-1">إلى تاريخ</label>
    <input type="date" name="end_date" class="form-control"
           value="{{ old('end_date', optional($v->end_date ?? null)->format('Y-m-d')) }}">
    @error('end_date') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
  </div>

  {{-- سبب الطلب --}}
  <div class="col-12">
    <label class="form-label text-inverse small mb-1">سبب الطلب</label>
    <textarea name="member_reason" class="form-control" rows="4"
              placeholder="اكتب السبب هنا...">{{ old('member_reason', $v->member_reason ?? '') }}</textarea>
    @error('member_reason') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
  </div>
</div>

<hr class="my-4 opacity-25">

<div class="d-flex flex-wrap gap-2">
  <button type="submit" class="btn btn-theme">{{ $submitText ?? 'حفظ' }}</button>
  <a href="{{ isset($v) && $v ? route('vacations.show',$v) : route('vacations.index') }}"
     class="btn btn-outline-inverse">إلغاء</a>
</div>
