
@php
  /** @var \App\Models\Vacation $vacation */
  $empName = $vacation->employee?->full_name
           ?: ($vacation->employee?->user?->name ?? '—');

  $cells = [
    ['label' => 'الموظف',      'value' => $empName],
    ['label' => 'نوع الإجازة', 'value' => $vacation->type?->name ?? '—'],
    ['label' => 'من تاريخ',    'value' => optional($vacation->start_date)->format('Y-m-d')],
    ['label' => 'إلى تاريخ',    'value' => optional($vacation->end_date)->format('Y-m-d')],
    ['label' => 'عدد الأيام',   'value' => $vacation->total_days],
    ['label' => 'الحالة',       'value' => view()->make('pages.vacations.partial.status-badge', ['vacation'=>$vacation])->render()],
  ];
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
  @foreach($cells as $c)
    <div class="p-3 rounded-lg border border-slate-700/40 bg-[#0f1524]">
      <div class="text-slate-400 text-xs mb-1">{{ $c['label'] }}</div>
      <div class="text-slate-100">{!! $c['value'] !!}</div>
    </div>
  @endforeach

  @if($vacation->member_reason)
    <div class="md:col-span-2 p-3 rounded-lg border border-slate-700/40 bg-[#0f1524]">
      <div class="text-slate-400 text-xs mb-1">سبب الطلب</div>
      <div class="text-slate-100 leading-relaxed">{{ $vacation->member_reason }}</div>
    </div>
  @endif

  @if($vacation->leader_reason)
    <div class="md:col-span-2 p-3 rounded-lg border border-slate-700/40 bg-[#0f1524]">
      <div class="text-slate-400 text-xs mb-1">ملاحظة TL</div>
      <div class="text-slate-100 leading-relaxed">{{ $vacation->leader_reason }}</div>
    </div>
  @endif

  @if($vacation->hr_reason)
    <div class="md:col-span-2 p-3 rounded-lg border border-slate-700/40 bg-[#0f1524]">
      <div class="text-slate-400 text-xs mb-1">ملاحظة HR</div>
      <div class="text-slate-100 leading-relaxed">{{ $vacation->hr_reason }}</div>
    </div>
  @endif
</div>
