@php
  /** @var \App\Models\Vacation $vacation */
  $empName = $vacation->employee?->full_name
           ?: ($vacation->employee?->user?->name ?? '—');

  $cells = [
    ['label' => 'الموظف',      'value' => e($empName)],
    ['label' => 'نوع الإجازة', 'value' => e($vacation->type?->name ?? '—')],
    ['label' => 'من تاريخ',    'value' => e(optional($vacation->start_date)->format('Y-m-d'))],
    ['label' => 'إلى تاريخ',    'value' => e(optional($vacation->end_date)->format('Y-m-d'))],
    ['label' => 'عدد الأيام',   'value' => e($vacation->total_days)],
    ['label' => 'الحالة',       'value' => view('pages.vacations.partial.status-badge', ['vacation'=>$vacation])->render()],
  ];
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
  @foreach($cells as $c)
    <div class="cell">
      <div class="label">{{ $c['label'] }}</div>
      <div class="value">{!! $c['value'] !!}</div>
    </div>
  @endforeach

  @if($vacation->member_reason)
    <div class="cell md:col-span-2">
      <div class="label">سبب الطلب</div>
      <div class="value" style="white-space:pre-line">{{ $vacation->member_reason }}</div>
    </div>
  @endif

  @if($vacation->leader_reason)
    <div class="cell md:col-span-2">
      <div class="label">ملاحظة TL</div>
      <div class="value" style="white-space:pre-line">{{ $vacation->leader_reason }}</div>
    </div>
  @endif

  @if($vacation->hr_reason)
    <div class="cell md:col-span-2">
      <div class="label">ملاحظة HR</div>
      <div class="value" style="white-space:pre-line">{{ $vacation->hr_reason }}</div>
    </div>
  @endif
</div>
