@php
  /** @var \App\Models\Vacation $vacation */
  $status = $vacation->status?->value ?? (string)($vacation->status ?? 'pending');
  $steps = [
    ['label'=>'تم إنشاء الطلب', 'on'=>true, 'at'=>optional($vacation->created_at)->format('Y-m-d H:i')],
    ['label'=>'اعتماد TL',      'on'=>in_array($status,['leader_approved','hr_approved']), 'at'=> $vacation->leader_reason ? '—' : null],
    ['label'=>'اعتماد HR',      'on'=>($status==='hr_approved'), 'at'=> $vacation->hr_reason ? '—' : null],
  ];
@endphp

<div class="timeline">
  @foreach($steps as $s)
    <div class="tstep position-relative">
      <span class="dot {{ $s['on'] ? 'on' : 'off' }}"></span>
      <div class="ttl">{{ $s['label'] }}</div>
      @if(!empty($s['at'])) <div class="when">{{ $s['at'] }}</div> @endif
    </div>
  @endforeach
</div>
