@extends('layout.default')
@section('title', 'تفاصيل طلب الإجازة')


@include('partial.theme.neon-vars')
@include('partial.toast-js')

@push('css')
    <style>
        /* ====== Core Neon Tokens ====== */
        :root {
            --text-main: #dfe7ff;
            --muted: #8ea2c6;
            --neon-1: #2afc98;
            --neon-2: #00e0ff;
            --neon-3: #ff5fff;
            --border: rgba(0, 224, 255, .18);
            --border-2: rgba(0, 224, 255, .28);
            --glow: 0 0 12px rgba(42, 252, 152, .35), 0 0 30px rgba(0, 224, 255, .18);
            --ring: 0 0 0 2px rgba(0, 224, 255, .35), 0 0 30px rgba(0, 224, 255, .22) inset;
        }

        body {
            color: var(--text-main);
        }

        /* ====== Shell ====== */
        .card-n {
            border: 1px solid var(--border);
            border-radius: 14px;
            box-shadow: var(--glow);
            /* background: linear-gradient(180deg, rgba(15, 22, 40, .96), rgba(9, 14, 27, .96)); */
        }

        .card-n .card-header {
            border-bottom: 1px solid var(--border);
            padding: 14px 16px;
        }

        .card-n .card-body {
            padding: 16px;
        }

        .neon-title {
            font-weight: 800;
            letter-spacing: .4px;
            margin: 0;
            background: linear-gradient(90deg, var(--neon-2), var(--neon-3));
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            text-shadow: 0 0 12px rgba(0, 224, 255, .28);
        }

        .sub-muted {
            color: var(--muted);
        }

        /* Buttons / Chips */
        .neon-btn {
            background: linear-gradient(90deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .12));
            color: #e9f6ff;
            border: 1px solid var(--border-2);
            padding: .5rem .9rem;
            border-radius: 10px;
            display: inline-flex;
            align-items: center;
            gap: .4rem;
            transition: .18s;
            box-shadow: var(--glow);
            text-decoration: none !important;
            cursor: pointer;
        }

        .neon-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 0 20px rgba(0, 224, 255, .35);
        }

        .neon-btn-outline {
            background: transparent;
        }

        .chip {
            display: inline-flex;
            gap: .45rem;
            align-items: center;
            padding: .28rem .6rem;
            border: 1px solid var(--border-2);
            border-radius: 999px;
            font-size: .8rem;
            background: rgba(0, 224, 255, .08);
            color: #cfe7ff;
        }

        /* ====== Stats strip ====== */
        .stat-n {
            border: 1px solid var(--border);
            border-radius: 12px;
            padding: .9rem 1rem;
            height: 100%;
            background: linear-gradient(135deg, rgba(0, 224, 255, .12), rgba(255, 95, 255, .10));
            box-shadow: var(--glow);
        }

        .stat-n .label {
            font-size: .78rem;
            color: var(--muted);
            margin-bottom: .25rem;
        }

        .stat-n .value {
            font-weight: 700;
            letter-spacing: .3px;
            color: #fff;
        }

        /* ====== Blocks ====== */
        .blk {
            border: 1px solid var(--border);
            border-radius: 12px;
            background: rgba(0, 224, 255, .04);
            box-shadow: var(--glow);
        }

        .blk-h {
            padding: .7rem 1rem;
            border-bottom: 1px solid var(--border);
            font-weight: 700;
            color: #eaf3ff;
        }

        .blk-b {
            padding: 1rem;
        }

        .field+.field {
            margin-top: .85rem;
        }

        .f-label {
            font-size: .8rem;
            color: var(--muted);
            margin-bottom: .25rem;
        }

        .f-val {
            white-space: pre-line;
            color: #eaf3ff;
        }

        /* ====== Timeline ====== */
        .timeline {
            position: relative;
            padding-right: 0;
            padding-left: 1rem;
        }

        .timeline:before {
            content: "";
            position: absolute;
            left: .36rem;
            top: .4rem;
            bottom: .4rem;
            width: 2px;
            background: linear-gradient(180deg, rgba(0, 224, 255, .55), rgba(255, 95, 255, .25));
            border-radius: 1px;
        }

        .t-item {
            position: relative;
            padding: .35rem 0 .35rem 1rem;
        }

        .t-dot {
            position: absolute;
            left: -.08rem;
            top: .55rem;
            width: .58rem;
            height: .58rem;
            border-radius: 50%;
            background: #6b7a93;
            box-shadow: 0 0 0 2px rgba(10, 16, 32, .9);
        }

        .t-item.done .t-dot {
            background: #2afc98;
            box-shadow: 0 0 10px rgba(42, 252, 152, .55);
        }

        .t-title {
            color: #fff;
            font-weight: 600;
        }

        .t-sub {
            color: var(--muted);
            font-size: .78rem;
        }

        /* ====== Actions row ====== */
        .actions .neon-btn {
            margin: .2rem;
        }

        @media(max-width:991.98px) {
            .stat-n {
                padding: .75rem .85rem;
            }
        }
    </style>
@endpush

@section('content')
    @php
        /** @var \App\Models\Vacation $vacation */
        $statusVal = $vacation->status?->value ?? (string) ($vacation->status ?? 'pending');
        $empName = $vacation->employee?->full_name ?: $vacation->employee?->user?->name ?? '—';
    @endphp

    <div class="container-fluid">
        <div class="card card-n">
            {{-- ===== Header ===== --}}
            <div class="card-header d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center" style="gap:.6rem;">
                    <a href="{{ route('vacations.index') }}" class="neon-btn neon-btn-outline">← رجوع</a>
                    <h5 class="neon-title m-0">طلب إجازة #{{ $vacation->id }}</h5>
                </div>

                <div class="d-flex align-items-center" style="gap:.6rem;">
                    @include('pages.vacations.partial.status-badge', ['vacation' => $vacation])
                    <a href="#" class="neon-btn neon-btn-outline" data-toggle="card-expand">تكبير</a>
                </div>
            </div>

            {{-- ===== Summary ===== --}}
            <div class="card-body pb-2">
                <div class="row g-3">
                    <div class="col-12 col-md-6 col-lg-4">
                        <div class="stat-n">
                            <div class="label">الموظف</div>
                            <div class="value" title="{{ $empName }}">{{ $empName }}</div>
                        </div>
                    </div>
                    <div class="col-6 col-lg-2">
                        <div class="stat-n">
                            <div class="label">نوع الإجازة</div>
                            <div class="value">{{ $vacation->type?->name ?? '—' }}</div>
                        </div>
                    </div>
                    <div class="col-6 col-lg-2">
                        <div class="stat-n">
                            <div class="label">من تاريخ</div>
                            <div class="value">{{ optional($vacation->start_date)->format('Y-m-d') }}</div>
                        </div>
                    </div>
                    <div class="col-6 col-lg-2">
                        <div class="stat-n">
                            <div class="label">إلى تاريخ</div>
                            <div class="value">{{ optional($vacation->end_date)->format('Y-m-d') }}</div>
                        </div>
                    </div>
                    <div class="col-6 col-lg-2">
                        <div class="stat-n">
                            <div class="label">عدد الأيام</div>
                            <div class="value">{{ $vacation->total_days }}</div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- ===== Content ===== --}}
            <div class="card-body pt-2">
                <div class="row g-3">
                    {{-- يسار --}}
                    <div class="col-lg-8">
                        <div class="blk mb-3">
                            <div class="blk-h">تفاصيل الطلب</div>
                            <div class="blk-b">
                                <div class="field">
                                    <div class="f-label">سبب الطلب</div>
                                    <div class="f-val">{{ $vacation->member_reason ?: '— لا يوجد سبب مُدخل —' }}</div>
                                </div>
                                <div class="field">
                                    <div class="f-label">حالة الطلب</div>
                                    @include('pages.vacations.partial.status-badge', [
                                        'vacation' => $vacation,
                                    ])
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- يمين --}}
                    <div class="col-lg-4">
                        <div class="blk mb-3">
                            <div class="blk-h">الحالة الزمنية</div>
                            <div class="blk-b">
                                @php
                                    $leaderAt = optional($vacation->leader_decision_at)->format('Y-m-d H:i');
                                    $hrAt = optional($vacation->hr_decision_at ?? null)->format('Y-m-d H:i');
                                    $steps = [
                                        [
                                            'label' => 'تم إنشاء الطلب',
                                            'done' => true,
                                            'at' => optional($vacation->created_at)->format('Y-m-d H:i'),
                                        ],
                                        [
                                            'label' => 'اعتماد TL',
                                            'done' =>
                                                in_array($statusVal, ['leader_approved', 'hr_approved', 'rejected']) &&
                                                !!$leaderAt,
                                            'at' => $leaderAt,
                                        ],
                                        [
                                            'label' => 'اعتماد HR',
                                            'done' => $statusVal === 'hr_approved' && !!$hrAt,
                                            'at' => $hrAt,
                                        ],
                                    ];
                                @endphp
                                <div class="timeline">
                                    @foreach ($steps as $s)
                                        <div class="t-item {{ $s['done'] ? 'done' : '' }}">
                                            <span class="t-dot"></span>
                                            <div class="t-title">{{ $s['label'] }}</div>
                                            @if (!empty($s['at']))
                                                <div class="t-sub">{{ $s['at'] }}</div>
                                            @endif
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="blk mb-3">
                            <div class="blk-h">سجلّ الملاحظات</div>
                            <div class="blk-b">
                                <div class="field">
                                    <div class="f-label">ملاحظة TL</div>
                                    <div class="f-val">{{ $vacation->leader_reason ?: '— لا توجد —' }}</div>
                                </div>
                                <div class="field">
                                    <div class="f-label">ملاحظة HR</div>
                                    <div class="f-val">{{ $vacation->hr_reason ?: '— لا توجد —' }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="blk">
                            <div class="blk-h d-flex align-items-center justify-content-between">إجراءات</div>
                            <div class="blk-b actions d-flex flex-wrap" style="gap:.5rem;">
                                @can('update', $vacation)
                                    <a href="{{ route('vacations.edit', $vacation) }}"
                                        class="neon-btn neon-btn-outline">تعديل</a>
                                @endcan

                                @can('delete', $vacation)
                                    <form class="js-vac-action" data-action="delete" method="POST"
                                        action="{{ route('vacations.destroy', $vacation) }}">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="neon-btn neon-btn-outline">حذف</button>
                                    </form>
                                @endcan

                                @can('leaderApprove', $vacation)
                                    <form class="js-vac-action" data-action="leader-approve" method="POST"
                                        action="{{ route('vacations.leader.approve', $vacation) }}">
                                        @csrf <button type="submit" class="neon-btn">اعتماد TL</button>
                                    </form>
                                @endcan

                                @can('hrApprove', $vacation)
                                    <form class="js-vac-action" data-action="hr-approve" method="POST"
                                        action="{{ route('vacations.hr.approve', $vacation) }}">
                                        @csrf <button type="submit" class="neon-btn">اعتماد HR</button>
                                    </form>
                                @endcan

                                @can('reject', $vacation)
                                    <form class="js-vac-action" data-action="reject" method="POST"
                                        action="{{ route('vacations.reject', $vacation) }}">
                                        @csrf <button type="submit" class="neon-btn neon-btn-outline">رفض</button>
                                    </form>
                                @endcan

                                @can('delete', $vacation)
                                    <form class="js-vac-action" data-action="delete" method="POST"
                                        action="{{ route('vacations.destroy', $vacation) }}">
                                        @csrf @method('DELETE')
                                        <button type="submit" class="neon-btn neon-btn-outline">إلغاء الطلب</button>
                                    </form>
                                @endcan
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Toast container (لو مش موجود في الـ layout) --}}
    <div class="toast-container position-fixed top-0 end-0 p-3" id="toastContainer" style="z-index:1080;"></div>
@endsection

@push('js')
    <script>
        // نفس الهاندلر بتاعك كما هو مع لمسات بسيطة
        document.addEventListener('click', async (e) => {
            const form = e.target.closest('form.js-vac-action');
            if (!form) return;
            e.preventDefault();

            const actionType = form.dataset.action; // leader-approve | hr-approve | reject | delete
            let ok = true,
                payload = {};

            if (actionType === 'delete') {
                ok = confirm('حذف الطلب؟');
            } else if (actionType === 'leader-approve') {
                const r = prompt('اعتماد التيم ليدر\n\nسبب (اختياري):', '');
                if (r === null) return;
                payload.reason = r || null;
            } else if (actionType === 'hr-approve') {
                const r = prompt('اعتماد HR\n\nسبب (اختياري):', '');
                if (r === null) return;
                payload.reason = r || null;
            } else if (actionType === 'reject') {
                const r = prompt('رفض الطلب\n\nسبب (اختياري):', '');
                if (r === null) return;
                payload.reason = r || null;
            }
            if (!ok) return;

            try {
                const res = await fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.content || '',
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(payload)
                });
                if (!res.ok) return window.toast.fromResponse(res, 'خطأ');

                const data = await res.json().catch(() => ({}));
                if (data?.toast && data.toast.variant && window.toast[data.toast.variant]) {
                    window.toast[data.toast.variant](data.toast.title || 'تم', data.toast.body || data
                        .message || '');
                } else {
                    window.toast.success('تم', data?.message || 'نُفِّذ الطلب بنجاح');
                }
                if (actionType === 'delete') {
                    setTimeout(() => window.location.href = `{{ route('vacations.index') }}`, 600);
                } else {
                    setTimeout(() => window.location.reload(), 600);
                }
            } catch (err) {
                window.toast.error('خطأ', err?.message || 'حدث خطأ غير متوقع');
            }
        });
    </script>
@endpush
