@once
  @push('css')
    {{-- DataTables CSS --}}
    <link href="/assets/plugins/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet">
    <link href="/assets/plugins/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet">

    <style>
      /* ====== Neon HUD – أزرار DataTables ====== */
      .dt-buttons{ display:flex; gap:.5rem; flex-wrap:wrap; justify-content:flex-end; }
      .btn.btn-dt{
        --accent:#0ea5e9;
        color:#e6f1ff;
        border-radius:12px;
        padding:.38rem .75rem;
        line-height:1.2;
        background:linear-gradient(180deg,
          color-mix(in oklab,var(--accent) 10%,#0b1524),
          color-mix(in oklab,var(--accent) 5%, #0f1c2d));
        border:1px solid color-mix(in oklab,var(--accent) 35%, #ffffff20);
        box-shadow:
          inset 0 0 0 1px rgba(255,255,255,.04),
          0 6px 16px color-mix(in oklab,var(--accent) 38%, transparent);
        transition: transform .08s ease, box-shadow .18s ease, border-color .18s ease;
      }
      .btn.btn-dt:hover{
        transform: translateY(-1px);
        box-shadow:
          inset 0 0 0 1px rgba(255,255,255,.06),
          0 10px 28px color-mix(in oklab,var(--accent) 70%, transparent),
          0 0 0 1px color-mix(in oklab,var(--accent) 45%, #ffffff10);
      }
      .dt-button-collection{
        background: rgba(18,32,51,.92);
        backdrop-filter: blur(8px);
        border: 1px solid rgba(255,255,255,.08);
        border-radius: 14px;
        padding: .35rem;
        box-shadow: 0 20px 50px rgba(0,0,0,.38),
                    0 0 28px color-mix(in oklab, var(--accent, #0ea5e9) 40%, transparent);
      }
      .dt-button-collection .dt-button{
        color:#e5e7eb; background:transparent; border:1px solid transparent;
        border-radius:10px; margin:.15rem 0; padding:.4rem .6rem;
      }
      .dt-button-collection .dt-button:hover{ background:rgba(255,255,255,.06); border-color:rgba(255,255,255,.08); }
      .dt-button-collection .dt-button.active{
        background: color-mix(in oklab, var(--accent, #0ea5e9) 18%, #0f1c2d);
        border-color: color-mix(in oklab, var(--accent, #0ea5e9) 45%, #ffffff20);
      }

      /* ====== Neon – عناصر عامة خفيفة (roles/vacations) ====== */
      .neon-card{background:#0b0f1a;border:1px solid #1b2437;border-radius:14px}
      .neon-card:hover{box-shadow:0 0 18px rgba(244,123,70,.15)}
      .neon-select{background:#0f1524;color:#e6f1ff;border:1px solid #1f2a44;border-radius:10px;padding:.6rem .8rem}
      .neon-select option{background:#0f1524;color:#e6f1ff}
      .neon-header{color:#eaf2ff}
      .neon-badge{padding:.25rem .6rem;border-radius:999px;font-size:.8rem;border:1px solid transparent}
      .nb-pending{color:#ffd27a;border-color:#664b12;box-shadow:0 0 10px rgba(255,210,122,.12) inset}
      .nb-leader{color:#9ee9ff;border-color:#11566b;box-shadow:0 0 10px rgba(158,233,255,.12) inset}
      .nb-hr{color:#9cffb4;border-color:#0f5a2d;box-shadow:0 0 10px rgba(156,255,180,.12) inset}
      .nb-rejected{color:#ff9ca3;border-color:#7a1b25;box-shadow:0 0 10px rgba(255,156,163,.12) inset}
      .btn-neon{border-radius:10px;border:1px solid #21304f;background:linear-gradient(180deg,#0f172a,#0c1220);color:#e6f1ff;padding:.5rem .8rem}
      .btn-neon:hover{box-shadow:0 0 16px rgba(12,122,122,.22)}
      .btn-neon-primary{border-color:#145b5b}
      .btn-neon-outline{background:transparent}

      /* شارة الأدوار (roles) */
      .badge-role{
        background:rgba(255,255,255,.08);
        border:1px solid rgba(255,255,255,.08);
        border-radius:10px; padding:.25rem .5rem; margin:.125rem;
        display:inline-flex; align-items:center; gap:.25rem;
      }
      .badge-role .btn-x{ border:none; background:transparent; color:#ef4444; padding:0 .15rem; line-height:1; }

      /* (اختياري) إخفاء أيقونة (+) Responsive في usersTable على الشاشات الكبيرة */
      @media (min-width: 992px) {
        #usersTable td.dtr-control:before, #usersTable th.dtr-control:before{ display: none !important; }
        #usersTable td.dtr-control, #usersTable th.dtr-control{ padding-left:.75rem !important; cursor: default !important; }
      }
      @media (max-width: 991.98px) {
        #usersTable td.dtr-control, #usersTable th.dtr-control{ cursor: pointer; }
      }

      @media (min-width: 992px) {
  .dataTables_wrapper table.dataTable.dt-no-plus > thead > tr > th.dtr-control:before,
  .dataTables_wrapper table.dataTable.dt-no-plus > tbody > tr > td.dtr-control:before { display: none !important; }
  .dataTables_wrapper table.dataTable.dt-no-plus > thead > tr > th.dtr-control,
  .dataTables_wrapper table.dataTable.dt-no-plus > tbody > tr > td.dtr-control { padding-left: .75rem !important; cursor: default !important; }
}
@media (max-width: 991.98px) {
  .dataTables_wrapper table.dataTable.dt-no-plus > thead > tr > th.dtr-control,
  .dataTables_wrapper table.dataTable.dt-no-plus > tbody > tr > td.dtr-control { cursor: pointer; }
}
@media (min-width: 992px) {
  .dataTables_wrapper table.dataTable.dt-no-plus > thead > tr > th.dtr-control:before,
  .dataTables_wrapper table.dataTable.dt-no-plus > tbody > tr > td.dtr-control:before {
    display: none !important;
  }
  .dataTables_wrapper table.dataTable.dt-no-plus > thead > tr > th.dtr-control,
  .dataTables_wrapper table.dataTable.dt-no-plus > tbody > tr > td.dtr-control {
    padding-left: .75rem !important;
    cursor: default !important;
  }
}
@media (max-width: 991.98px) {
  .dataTables_wrapper table.dataTable.dt-no-plus > thead > tr > th.dtr-control,
  .dataTables_wrapper table.dataTable.dt-no-plus > tbody > tr > td.dtr-control {
    cursor: pointer;
  }
}

    </style>
  @endpush

  @push('js')
    {{-- DataTables JS --}}
    <script src="/assets/plugins/datatables.net/js/dataTables.min.js"></script>
    <script src="/assets/plugins/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.colVis.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>

    <script>
      // مساحة أسماء موحدة
      window.DT = window.DT || {};
      window.DT_INSTANCES = window.DT_INSTANCES || {};

      // أزرار النيون
      DT.neonButtons = (exportCols=[]) => ([
        { extend:'copy',  className:'btn btn-dt', exportOptions:{columns:exportCols} },
        { extend:'csv',   className:'btn btn-dt', exportOptions:{columns:exportCols} },
        { extend:'excel', className:'btn btn-dt', exportOptions:{columns:exportCols} },
        { extend:'pdf',   className:'btn btn-dt', exportOptions:{columns:exportCols}, orientation:'landscape', pageSize:'LEGAL' },
        { extend:'print', className:'btn btn-dt', exportOptions:{columns:exportCols} },
        { extend:'colvis',className:'btn btn-dt', text:'Columns' },
        { extend:'pageLength', className:'btn btn-dt' }
      ]);

      /**
       * DT.make({ id, ajax, columns, order, exportColumns, responsive('inline'|true|false), serverSide, searchDelay, filtersHook })
       * - يـResolve filtersHook عند كل طلب AJAX (علشان الفلاتر تشتغل دايمًا)
       * - يطبع أخطاء السيرفر في الـConsole، ويستعمل window.toast لو متاح
       */
      DT.make = function(cfg){
        const idSel = '#'+cfg.id;
          const el = document.querySelector(idSel);

        if (el && cfg.responsive === 'inline' && !cfg.keepPlus) {
            el.classList.add('dt-no-plus');
        }
        const columnDefs = [
             { targets: '_all', className: 'text-center align-middle' }
        ];

        const dt = new DataTable(idSel, {
          serverSide: cfg.serverSide ?? true,
          processing: true,
          searchDelay: cfg.searchDelay ?? 300,
          responsive: (cfg.responsive === 'inline'
            ? { details:{ type:'inline', target:'tr', renderer: DataTable.Responsive.renderer.tableAll() } }
            : (cfg.responsive ? { details:true } : false)
          ),
          ajax: {
            url: cfg.ajax,
            data: d => {
              // resolve hook dynamically each request
              const hookName = cfg.filtersHook;
              const hookFn = (typeof hookName === 'string' && typeof window[hookName] === 'function')
                ? window[hookName]
                : null;
              const extra = hookFn ? (hookFn() || {}) : {};
              return Object.assign(d, extra);
            },
            error: (xhr, textStatus, errorThrown) => {
              console.error('[DataTables AJAX Error]', {status:xhr.status, error:errorThrown, body:xhr.responseText});
              if (window.toast?.error) {
                window.toast.error('Load failed', `(${xhr.status}) ${errorThrown || 'Unknown error'}`);
              }
            }
          },
          order: cfg.order || [[0,'desc']],
          columns: (cfg.columns||[]).map(col=>{
            if (col.render && typeof col.render === 'string'){
              const name = col.render;
              col.render = function(data,type,row,meta){
                return (window.DT.renderers && typeof window.DT.renderers[name] === 'function')
                  ? window.DT.renderers[name](data,row,meta)
                  : (data ?? '—');
              }
            }
            return col;
          }),
         columnDefs, // 👈 إضافة مهمة
      dom: "<'row mb-3'<'col-12 text-end'B>>t<'d-flex align-items-center mt-3'<'me-auto'i><'mb-0'p>>",
          //   dom: "<'row mb-3'<'col-12 text-end'B>>t<'d-flex align-items-center mt-3'<'me-auto'i><'mb-0'p>>",
          buttons: DT.neonButtons(cfg.exportColumns || [])
        });

        // خليه متاح بإيديه
        window.DT_INSTANCES[cfg.id] = dt;
        return dt;
      };

      // Renderers افتراضية خفيفة – الصفحات ممكن تزود/تستبدل
      DT.renderers = DT.renderers || {
        checkbox: (data,row)=> `<input type="checkbox" class="row-check" value="${row.id}" aria-label="Select #${row.id}">`
      };
    </script>
  @endpush
@endonce
