@php
  $dtId = $id ?? 'datatable';

  $cfg = [
    'id'                 => $dtId,
    'ajax'               => $ajax ?? '',
    'columns'            => $columns ?? [],
    'order'              => $order ?? null,
    'exportColumns'      => $exportColumns ?? [],
    'responsive'         => $responsive ?? 'inline',
    'serverSide'         => $serverSide ?? true,
    'searchDelay'        => $searchDelay ?? 300,
    'filtersHook'        => $filtersHook ?? null,

    // اختياري: استثناءات محاذاة لو حبيت (indices تبدأ من 0)
    'leftAlignedTargets'  => $leftAlignedTargets  ?? [],
    'rightAlignedTargets' => $rightAlignedTargets ?? [],
  ];
@endphp

{{-- نجبر سنترة الجدول الحالي فقط --}}
<style>
  #{{ $dtId }} > thead > tr > th,
  #{{ $dtId }} > tbody > tr > td {
    text-align: center !important;
    vertical-align: middle !important;
  }
</style>

<table id="{{ $dtId }}" class="table table-striped align-middle w-100">
  <thead>
    {!! $thead ?? '' !!}
  </thead>
  <tbody></tbody>
</table>

@push('js')
<script>
  (function(){
    const cfg = @json($cfg, JSON_UNESCAPED_UNICODE);
    window.DT_INSTANCES = window.DT_INSTANCES || {};
    window.DT_INSTANCES[cfg.id] = DT.make(cfg);
  })();
</script>
@endpush
{{--
  شرح المعطيات:
    - id:                 معرف الداتا تيبلز (مهم جداً)
    - ajax:               رابط جيسون الداتا تيبلز
    - columns:            أعمدة الداتا تيبلز (مصدر البيانات)
    - order:              ترتيب الأعمدة (مثال: [[0,'desc']])
    - exportColumns:      أعمدة التصدير (مثال: [0,1,2,3,4,5])
    - responsive:         نمط الاستجابة (مثال: 'inline' أو true أو false)
    - serverSide:         هل الجلب من السيرفر؟ (افتراضي true)
    - searchDelay:        تأخير البحث بالمللي ثانية (افتراضي 300)
    - filtersHook:        اسم دالة الجافاسكريبت التي تعيد الفلاتر (مثال: 'myFilters')
    - leftAlignedTargets: مصفوفة أرقام أعمدة المحاذاة اليسرى (مثال: [0,1])
    - rightAlignedTargets:مصفوفة أرقام أعمدة المحاذاة اليمنى (مثال: [6,7])
    - thead:              رأس الجدول (HTML) اختياري
--}}
