<div class="dropdown-menu dropdown-menu-end mt-1 w-300px fs-11px pt-1">
    <h6 class="dropdown-header fs-10px mb-1">NOTIFICATIONS</h6>
    <div class="dropdown-divider mt-1"></div>

    <div id="notif-list">
        @php
            $items = auth()->user()->notifications()->latest()->limit(10)->get();
            $APP = rtrim(config('app.url'), '/'); // نقرأ APP_URL من .env
        @endphp

        @forelse ($items as $n)
            @php
                $d = (array) $n->data;
                $icon = match ($d['model'] ?? '') {
                    'vacation' => 'bi-umbrella',
                    'attendance_permit' => 'bi-alarm',
                    default => 'bi-bell',
                };

                // مسار نسبي يمر على الكونترولر (mark-as-read)
                $rel = route('notifications.open.id', $n->id, false);
                // نكوّن لينك مطلق مبني على APP_URL
                $href = $APP . $rel;
            @endphp

            <a href="{{ $href }}" class="d-flex align-items-center py-10px dropdown-item text-wrap fw-semibold">
                <div class="fs-20px w-20px">
                    <i class="bi {{ $icon }} text-theme"></i>
                </div>
                <div class="flex-1 flex-wrap ps-3">
                    <div class="mb-1 text-inverse">
                        {{ $d['title'] ?? 'تنبيه' }}
                        @if (is_null($n->read_at))
                            <span class="badge bg-danger ms-2 align-middle"
                                style="width:6px;height:6px;border-radius:50%;padding:0;">&nbsp;</span>
                        @endif
                    </div>
                    <div class="small text-inverse text-opacity-50">
                        {{ optional($n->created_at)->diffForHumans() }}
                    </div>
                </div>
                <div class="ps-2 fs-16px"><i class="bi bi-chevron-right"></i></div>
            </a>
        @empty
            <div id="notif-empty" class="text-center text-muted py-3">لا توجد إشعارات</div>
        @endforelse
    </div>

    <hr class="my-0">
    <div class="py-10px mb-n2 text-center">
        <a href="{{ route('notifications.index') }}" class="text-decoration-none fw-bold">SEE ALL</a>
    </div>
</div>
