{{-- <!-- BEGIN #sidebar -->
<div id="sidebar" class="app-sidebar">
    <!-- BEGIN scrollbar -->
    <div class="app-sidebar-content" data-scrollbar="true" data-height="100%">
        <!-- BEGIN menu -->
        <div class="menu">
            @php
                $currentUrl = (Request::path() != '/') ? '/'. Request::path() : '/';

                if (!function_exists('renderSubMenu')) {
                    function renderSubMenu($value, $currentUrl) {
                        $subMenu = '';
                        $GLOBALS['sub_level'] += 1;
                        $GLOBALS['active'][$GLOBALS['sub_level']] = '';
                        $currentLevel = $GLOBALS['sub_level'];
                        foreach ($value as $key => $menu) {
                            $GLOBALS['childparent_level'] = '';

                            $subSubMenu = '';
                            $hasSub = (!empty($menu['children'])) ? 'has-sub' : '';
                            $menuUrl = (!empty($menu['url'])) ? $menu['url'] : '#';
                            $menuCaret = (!empty($hasSub)) ? '<span class="menu-caret"><b class="caret"></b></span>' : '';
                            $menuText = (!empty($menu['text'])) ? '<span class="menu-text">'. $menu['text'] .'</span>' : '';

                            if (!empty($menu['children'])) {
                                $subSubMenu .= '<div class="menu-submenu">';
                                $subSubMenu .= renderSubMenu($menu['children'], $currentUrl);
                                $subSubMenu .= '</div>';
                            }

                            $active = ($currentUrl == $menuUrl) ? 'active' : '';
                            if (!empty(config('sidebar.activeUrl'))) {
                                $active = (config('sidebar.activeUrl') == $menuUrl) ? 'active' : '';
                            }
                            if ($active) {
                                $GLOBALS['parent_active'] = true;
                                $GLOBALS['active'][$GLOBALS['sub_level'] - 1] = true;
                            }
                            if (!empty($GLOBALS['active'][$currentLevel])) {
                                $active = 'active';
                            }

                            $subMenu .= '
                                <div class="menu-item '. $hasSub .' '. $active .'">
                                    <a href="'. $menuUrl .'" class="menu-link">'. $menuText . $menuCaret .'</a>
                                    '. $subSubMenu .'
                                </div>
                            ';
                        }
                        return $subMenu;
                    }
                }

                // Updated menu configuration to match the new sidebar
                $menuConfig = [
                    [
                        'is_header' => true,
                        'text' => 'Navigation'
                    ],
                    [
                        'url' => '/',
                        'icon' => 'bi bi-cpu',
                        'text' => 'Dashboard'
                    ],
                    [
                        'url' => '/analytics',
                        'icon' => 'bi bi-bar-chart',
                        'text' => 'Analytics'
                    ],
                    [
                        'url' => '/departments',
                        'icon' => 'bi bi-building',
                        'text' => 'Departments'
                    ],
                    [
                        'icon' => 'bi bi-envelope',
                        'text' => 'Email',
                        'children' => [
                            ['url' => '/email/inbox', 'text' => 'Inbox'],
                            ['url' => '/email/compose', 'text' => 'Compose'],
                            ['url' => '/email/detail', 'text' => 'Detail']
                        ]
                    ],
                    [
                        'is_header' => true,
                        'text' => 'Components'
                    ],
                    [
                        'url' => '/widgets',
                        'icon' => 'bi bi-columns-gap',
                        'text' => 'Widgets'
                    ],
                    [
                        'icon' => 'bi bi-stars',
                        'text' => 'AI Studio',
                        'children' => [
                            ['url' => '/ai/chat', 'text' => 'AI Chat'],
                            ['url' => '/ai/image-generator', 'text' => 'AI Image Generator']
                        ]
                    ],
                    [
                        'icon' => 'bi bi-bag-check',
                        'text' => 'POS System',
                        'children' => [
                            ['url' => '/pos/customer-order', 'text' => 'Customer Order'],
                            ['url' => '/pos/kitchen-order', 'text' => 'Kitchen Order'],
                            ['url' => '/pos/counter-checkout', 'text' => 'Counter Checkout'],
                            ['url' => '/pos/table-booking', 'text' => 'Table Booking'],
                            ['url' => '/pos/menu-stock', 'text' => 'Menu Stock']
                        ]
                    ],
                    [
                        'icon' => 'bi bi-controller',
                        'text' => 'UI Kits',
                        'children' => [
                            ['url' => '/ui/bootstrap', 'text' => 'Bootstrap'],
                            ['url' => '/ui/buttons', 'text' => 'Buttons'],
                            ['url' => '/ui/card', 'text' => 'Card'],
                            ['url' => '/ui/icons', 'text' => 'Icons'],
                            ['url' => '/ui/modal-notification', 'text' => 'Modal & Notification'],
                            ['url' => '/ui/typography', 'text' => 'Typography'],
                            ['url' => '/ui/tabs-accordions', 'text' => 'Tabs & Accordions']
                        ]
                    ],
                    [
                        'icon' => 'bi bi-pen',
                        'text' => 'Forms',
                        'children' => [
                            ['url' => '/form/elements', 'text' => 'Form Elements'],
                            ['url' => '/form/plugins', 'text' => 'Form Plugins'],
                            ['url' => '/form/wizards', 'text' => 'Wizards']
                        ]
                    ],
                    [
                        'icon' => 'bi bi-grid-3x3',
                        'text' => 'Tables',
                        'children' => [
                            ['url' => '/table/elements', 'text' => 'Table Elements'],
                            ['url' => '/table/plugins', 'text' => 'Table Plugins']
                        ]
                    ],
                    [
                        'icon' => 'bi bi-pie-chart',
                        'text' => 'Charts',
                        'children' => [
                            ['url' => '/chart/js', 'text' => 'Chart.js'],
                            ['url' => '/chart/apex', 'text' => 'Apexcharts.js']
                        ]
                    ],
                    [
                        'url' => '/map',
                        'icon' => 'bi bi-compass',
                        'text' => 'Map'
                    ],
                    [
                        'icon' => 'bi bi-layout-sidebar',
                        'text' => 'Layout',
                        'children' => [
                            ['url' => '/layout/starter', 'text' => 'Starter Page'],
                            ['url' => '/layout/fixed-footer', 'text' => 'Fixed Footer'],
                            ['url' => '/layout/full-height', 'text' => 'Full Height'],
                            ['url' => '/layout/full-width', 'text' => 'Full Width'],
                            ['url' => '/layout/boxed-layout', 'text' => 'Boxed Layout'],
                            ['url' => '/layout/collapsed-sidebar', 'text' => 'Collapsed Sidebar'],
                            ['url' => '/layout/top-nav', 'text' => 'Top Nav'],
                            ['url' => '/layout/mixed-nav', 'text' => 'Mixed Nav'],
                            ['url' => '/layout/mixed-nav-boxed-layout', 'text' => 'Mixed Nav Boxed Layout']
                        ]
                    ],
                    [
                        'icon' => 'bi bi-collection',
                        'text' => 'Pages',
                        'children' => [
                            ['url' => '/page/scrum-board', 'text' => 'Scrum Board'],
                            ['url' => '/page/products', 'text' => 'Products'],
                            ['url' => '/page/product-details', 'text' => 'Product Details'],
                            ['url' => '/page/orders', 'text' => 'Orders'],
                            ['url' => '/page/order-details', 'text' => 'Order Details'],
                            ['url' => '/page/gallery', 'text' => 'Gallery'],
                            ['url' => '/page/search-results', 'text' => 'Search Results'],
                            ['url' => '/page/coming-soon', 'text' => 'Coming Soon Page'],
                            ['url' => '/page/404-error', 'text' => '404 Error Page'],
                            ['url' => '/page/login', 'text' => 'Login'],
                            ['url' => '/page/register', 'text' => 'Register'],
                            ['url' => '/page/messenger', 'text' => 'Messenger'],
                            ['url' => '/page/data-management', 'text' => 'Data Management'],
                            ['url' => '/page/file-manager', 'text' => 'File Manager'],
                            ['url' => '/page/pricing', 'text' => 'Pricing Page']
                        ]
                    ],
                    [
                        'url' => '/landing',
                        'icon' => 'bi bi-diagram-3',
                        'text' => 'Landing Page'
                    ],
                    [
                        'is_divider' => true
                    ],
                    [
                        'is_header' => true,
                        'text' => 'Users'
                    ],
                    [
                        'url' => '/profile',
                        'icon' => 'bi bi-people',
                        'text' => 'Profile'
                    ],
                    [
                        'url' => '/calendar',
                        'icon' => 'bi bi-calendar4',
                        'text' => 'Calendar'
                    ],
                    [
                        'url' => '/settings',
                        'icon' => 'bi bi-gear',
                        'text' => 'Settings'
                    ],
                    [
                        'url' => '/helper',
                        'icon' => 'bi bi-gem',
                        'text' => 'Helper'
                    ]
                ];

                foreach ($menuConfig as $key => $menu) {
                    $GLOBALS['parent_active'] = '';

                    $hasSub = (!empty($menu['children'])) ? 'has-sub' : '';
                    $menuUrl = (!empty($menu['url'])) ? $menu['url'] : '#';
                    $menuLabel = (!empty($menu['label'])) ? '<span class="menu-icon-label">'. $menu['label'] .'</span>' : '';
                    $menuIcon = (!empty($menu['icon'])) ? '<span class="menu-icon"><i class="'. $menu['icon'] .'"></i>'. $menuLabel .'</span>' : '';
                    $menuText = (!empty($menu['text'])) ? '<span class="menu-text">'. $menu['text'] .'</span>' : '';
                    $menuCaret = (!empty($hasSub)) ? '<span class="menu-caret"><b class="caret"></b></span>' : '';
                    $menuSubMenu = '';

                    if (!empty($menu['children'])) {
                        $GLOBALS['sub_level'] = 0;
                        $menuSubMenu .= '<div class="menu-submenu">';
                        $menuSubMenu .= renderSubMenu($menu['children'], $currentUrl);
                        $menuSubMenu .= '</div>';
                    }
                    $active = (!empty($menu['url']) && $currentUrl == $menu['url']) ? 'active' : '';
                    $active = (empty($active) && !empty($GLOBALS['parent_active'])) ? 'active' : $active;

                    if (!empty(config('sidebar.activeUrl'))) {
                        $active = (!empty($menu['url']) && config('sidebar.activeUrl') == $menu['url']) ? 'active' : '';
                        $active = (empty($active) && !empty($GLOBALS['parent_active'])) ? 'active' : $active;
                    }
                    if (!empty($menu['is_header'])) {
                        echo '<div class="menu-header">'. $menu['text'] .'</div>';
                    } else if (!empty($menu['is_divider'])) {
                        echo '<div class="menu-divider"></div>';
                    } else {
                        echo '
                            <div class="menu-item '. $hasSub .' '. $active .'">
                                <a href="'. $menuUrl .'" class="menu-link">
                                    '. $menuIcon .'
                                    '. $menuText .'
                                    '. $menuCaret .'
                                </a>
                                '. $menuSubMenu .'
                            </div>
                        ';
                    }
                }
            @endphp
        </div>
        <!-- END menu -->
        <div class="p-3 px-4 mt-auto">
            <a href="https://seantheme.com/hud-laravel/documentation/index.html" target="_blank" class="btn d-block btn-outline-theme">
                <i class="fa fa-code-branch me-2 ms-n2 opacity-5"></i> Documentation
            </a>
        </div>
    </div>
    <!-- END scrollbar -->
</div>
<!-- END #sidebar -->

<!-- BEGIN mobile-sidebar-backdrop -->
<button class="app-sidebar-mobile-backdrop" data-toggle-class="app-sidebar-mobile-toggled" data-toggle-target=".app"></button>
<!-- END mobile-sidebar-backdrop --> --}}
<!-- BEGIN #sidebar -->
{{-- <div id="sidebar" class="app-sidebar">
  <div class="app-sidebar-content" data-scrollbar="true" data-height="100%">
    <div class="menu">
      @php
        $currentUrl = request()->path() !== '/' ? '/'.request()->path() : '/';
        $menu = config('sidebar.menu', []);

        // Gate: role/roles/can
        function menuCanSee(array $item): bool {
          $u = auth()->user();
          if (!$u) return true; // لو عايز تخفي لغير المسجلين: ارجع false هنا
          if (isset($item['role']))  { if (!$u->hasRole($item['role']))  return false; }
          if (isset($item['roles'])) { if (!$u->hasAnyRole((array)$item['roles'])) return false; }
          if (isset($item['can']))   {
            $perms = (array)$item['can'];
            $ok = false;
            foreach ($perms as $p) { if ($u->can($p)) { $ok = true; break; } }
            if (!$ok) return false;
          }
          return true;
        }

        // Active detection: by url (with wildcard)
        function menuIsActive(array $item, string $currentUrl): bool {
          $url = $item['url'] ?? null;
          if ($url) {
            $pattern = ltrim($url, '/');
            if (request()->is($pattern) || request()->is($pattern.'/*') || $currentUrl === $url) {
              return true;
            }
          }
          if (!empty($item['children'])) {
            foreach ($item['children'] as $c) {
              if (menuIsActive($c, $currentUrl)) return true;
            }
          }
          return false;
        }

        // Render recursion
        $render = function(array $items) use (&$render, $currentUrl) {
          $html = '';
          foreach ($items as $item) {
            // headers / dividers
            if (!empty($item['is_header'])) {
              $html .= '<div class="menu-header">'.e($item['text']).'</div>';
              continue;
            }
            if (!empty($item['is_divider'])) {
              $html .= '<div class="menu-divider"></div>';
              continue;
            }

            // permission gates
            if (!menuCanSee($item)) continue;

            $hasSub = !empty($item['children']);
            $url    = $item['url']   ?? '#';
            $icon   = $item['icon']  ?? null;
            $text   = $item['text']  ?? '';
            $target = $item['target']?? null;

            $active = menuIsActive($item, $currentUrl) ? 'active' : '';
            $caret  = $hasSub ? '<span class="menu-caret"><b class="caret"></b></span>' : '';
            $iconEl = $icon ? '<span class="menu-icon"><i class="'.e($icon).'"></i></span>' : '';
            $targetAttr = $target ? ' target="'.e($target).'" rel="noopener"' : '';

            $html .= '<div class="menu-item '.($hasSub?'has-sub':'').' '.$active.'">';
            $html .=   '<a href="'.e($url).'" class="menu-link"'.$targetAttr.'>';
            $html .=     $iconEl.'<span class="menu-text">'.e($text).'</span>'.$caret;
            $html .=   '</a>';

            if ($hasSub) {
              $html .= '<div class="menu-submenu">'.$render($item['children']).'</div>';
            }
            $html .= '</div>';
          }
          return $html;
        };

        echo $render($menu);
      @endphp
    </div>

    <div class="p-3 px-4 mt-auto">
      <a href="https://seantheme.com/hud-laravel/documentation/index.html" target="_blank" class="btn d-block btn-outline-theme">
        <i class="fa fa-code-branch me-2 ms-n2 opacity-5"></i> Documentation
      </a>
    </div>
  </div>
</div>

<button class="app-sidebar-mobile-backdrop" data-toggle-class="app-sidebar-mobile-toggled" data-toggle-target=".app"></button> --}}



<div id="sidebar" class="app-sidebar accent-secondary">
    <div class="app-sidebar-content" data-scrollbar="true" data-height="100%">
        <div class="menu">
            @php
                use Illuminate\Support\Facades\Gate;
                use Illuminate\Support\Facades\Route;

                $currentUrl = request()->path() !== '/' ? '/' . request()->path() : '/';
                $menu = config('sidebar.menu', []);

                // ===== Helpers =====

                // هل العنصر مرئي للمستخدم الحالي؟
                function menuItemVisible(array $item): bool
                {
                    $u = auth()->user();

                    // visible: Closure اختياري
                    if (isset($item['visible']) && is_callable($item['visible'])) {
                        try {
                            if (!$item['visible']()) {
                                return false;
                            }
                        } catch (\Throwable $e) {
                            return false;
                        }
                    }

                    // لو عايز تخفي لغير المسجلين (اختياري) — حالياً نظهر للجميع
                    if (!$u) {
                        // return false;
                        return true;
                    }

                    // role واحد
                    if (isset($item['role'])) {
                        if (!$u->hasRole($item['role'])) {
                            return false;
                        }
                    }

                    // roles مصفوفة
                    if (isset($item['roles'])) {
                        if (!$u->hasAnyRole((array) $item['roles'])) {
                            return false;
                        }
                    }

                    // can: يقبل سترينج أو مصفوفة — نعتبره "أي واحدة تكفي"
                    if (isset($item['can'])) {
                        $perms = (array) $item['can'];
                        $ok = false;
                        foreach ($perms as $p) {
                            if ($u->can($p)) {
                                $ok = true;
                                break;
                            }
                        }
                        if (!$ok) {
                            return false;
                        }
                    }

                    // can_any: Gate::any على مجموعة صلاحيات
                    if (isset($item['can_any'])) {
                        $perms = (array) $item['can_any'];
                        if (!Gate::any($perms)) {
                            return false;
                        }
                    }

                    return true;
                }

                // الحصول على النص (i18n أو text)
                function menuItemText(array $item): string
                {
                    if (!empty($item['i18n'])) {
                        return __($item['i18n']);
                    }
                    return (string) ($item['text'] ?? '');
                }

                // الحصول على الرابط (route أو url)
                function menuItemUrl(array $item): string
                {
                    if (!empty($item['route'])) {
                        try {
                            return route($item['route']);
                        } catch (\Throwable $e) {
                        }
                    }
                    return $item['url'] ?? '#';
                }

                // اكتشاف حالة الـ active
                function menuItemActive(array $item, string $currentUrl): bool
                {
                    // أنماط مخصّصة
                    if (!empty($item['active'])) {
                        foreach ((array) $item['active'] as $pattern) {
                            $pattern = ltrim((string) $pattern, '/');
                            if ($pattern === '') {
                                continue;
                            }
                            if (request()->is($pattern) || request()->is($pattern . '/*')) {
                                return true;
                            }
                        }
                    }

                    // بناءً على url
                    if (!empty($item['url'])) {
                        $pattern = ltrim($item['url'], '/');
                        if ($pattern !== '') {
                            if (
                                request()->is($pattern) ||
                                request()->is($pattern . '/*') ||
                                $currentUrl === $item['url']
                            ) {
                                return true;
                            }
                        } else {
                            // حالة الصفحة الرئيسية
                            if (url()->current() === url('/')) {
                                return true;
                            }
                        }
                    }

                    // أي طفل Active؟
                    if (!empty($item['children'])) {
                        foreach ($item['children'] as $c) {
                            if (menuItemActive($c, $currentUrl)) {
                                return true;
                            }
                        }
                    }

                    return false;
                }

                // شارة (Badge) اختيارية: Closure ترجع نص/رقم
                function menuItemBadge(array $item)
                {
                    if (isset($item['badge']) && is_callable($item['badge'])) {
                        try {
                            return $item['badge']();
                        } catch (\Throwable $e) {
                            return null;
                        }
                    }
                    return null;
                }

                // ===== Render (Recursive) =====
                $render = function (array $items) use (&$render, $currentUrl) {
                    $html = '';
                    foreach ($items as $item) {
                        // Header
                        if (!empty($item['is_header'])) {
                            $html .= '<div class="menu-header">' . e(menuItemText($item)) . '</div>';
                            continue;
                        }

                        // Divider
                        if (!empty($item['is_divider'])) {
                            $html .= '<div class="menu-divider"></div>';
                            continue;
                        }

                        // صلاحيات/ظهور
                        if (!menuItemVisible($item)) {
                            continue;
                        }

                        $hasSub = !empty($item['children']);
                        $url = menuItemUrl($item);
                        $icon = $item['icon'] ?? null;
                        $target = $item['target'] ?? null;
                        $text = menuItemText($item);
                        $badge = menuItemBadge($item);

                        $active = menuItemActive($item, $currentUrl) ? 'active' : '';
                        $caret = $hasSub ? '<span class="menu-caret"><b class="caret"></b></span>' : '';
                        $iconEl = $icon ? '<span class="menu-icon"><i class="' . e($icon) . '"></i></span>' : '';
                        $targetAttr = $target ? ' target="' . e($target) . '" rel="noopener"' : '';

                        // دعم class من الكونفيج + accent (ينعكس في CSS نيون)
                        $extraClass = trim((string) ($item['class'] ?? ''));
                        $itemClass = trim(
                            'menu-item ' . ($hasSub ? 'has-sub' : '') . ' ' . $active . ' ' . $extraClass,
                        );
                        $dataAccent = isset($item['accent']) ? ' data-accent="' . e($item['accent']) . '"' : '';

                        // Logout خاص: عندك route('logout') = POST
                        $isLogout = isset($item['url']) && trim($item['url'], '/') === 'logout';

                        $html .= '<div class="' . e($itemClass) . '"' . $dataAccent . '>';

                        if ($isLogout) {
                            $html .=
                                '<a href="#" class="menu-link" onclick="event.preventDefault();document.getElementById(\'logout-form\').submit();">';
                            $html .= $iconEl . '<span class="menu-text">' . e($text) . '</span>';
                            $html .= '</a>';
                            // form مرة واحدة أسفل السايدبار (لو مش موجود) — موجود تحت الفيو
                        } else {
                            $html .=
                                '<a href="' .
                                e($hasSub ? 'javascript:void(0)' : $url) .
                                '" class="menu-link"' .
                                $targetAttr .
                                '>';
                            $html .= $iconEl . '<span class="menu-text">' . e($text) . '</span>';
                            if (!is_null($badge)) {
                                $html .= '<span class="menu-badge">' . e((string) $badge) . '</span>';
                            }
                            $html .= $caret;
                            $html .= '</a>';
                        }

                        if ($hasSub) {
                            $html .= '<div class="menu-submenu">' . $render($item['children']) . '</div>';
                        }

                        $html .= '</div>';
                    }
                    return $html;
                };

                echo $render($menu);
            @endphp
        </div>

        {{-- زر توثيق القالب --}}
        <div class="p-3 px-4 mt-auto">
            <a href="https://seantheme.com/hud-laravel/documentation/index.html" target="_blank"
                class="btn d-block btn-outline-theme">
                <i class="fa fa-code-branch me-2 ms-n2 opacity-5"></i> Documentation
            </a>
        </div>
    </div>
</div>

{{-- Logout form (مرة واحدة) --}}
<form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
    @csrf
</form>

<button class="app-sidebar-mobile-backdrop" data-toggle-class="app-sidebar-mobile-toggled"
    data-toggle-target=".app"></button>
