<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\DepartmentController;
use App\Http\Controllers\Api\TeamMemberController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/media-link', [App\Http\Controllers\Api\MediaLinkController::class, 'getMediaLink']);
    Route::post('/media-link', [\App\Http\Controllers\web\MediaLinkController::class, 'store']);
    Route::get('/quotation', [App\Http\Controllers\Api\QuotationController::class, 'get']);
    Route::post('/quotation', [\App\Http\Controllers\Api\QuotationController::class, 'store']);

    // Departments routes
    // Route::apiResource('departments', DepartmentController::class);

    // Team Members routes
    Route::apiResource('team-members', TeamMemberController::class);

    // Teams routes - temporarily commented out due to missing TeamController
    // Route::apiResource('teams', TeamController::class);
    // Route::post('teams/{team}/attach-member', [TeamController::class, 'attachMember']);
    // Route::post('teams/{team}/detach-member', [TeamController::class, 'detachMember']);
});
