<?php

use App\Http\Controllers\web\AttendanceController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Attendance Routes
|--------------------------------------------------------------------------
|
| Here is where you can register attendance routes for your application.
|
*/

Route::middleware('auth')->group(function () {
    Route::post('/attendance/check-in', [AttendanceController::class, 'checkIn'])->name('attendance.check-in');
    Route::post('/attendance/check-out', [AttendanceController::class, 'checkOut'])->name('attendance.check-out');
    Route::get('/attendance/history', [AttendanceController::class, 'history'])->name('attendance.history');
    Route::get('/attendance', [AttendanceController::class, 'index'])->name('attendance.index');
    Route::get('/leader/attendance', [AttendanceController::class, 'leaderView'])->name('leader.attendance');

    // HR Manager Attendance Routes
    Route::get('/hr/attendance/dashboard', [AttendanceController::class, 'hrDashboard'])->name('hr.attendance.dashboard');
    Route::get('/hr/attendance/department/{departmentId}/employees', [AttendanceController::class, 'departmentEmployees'])->name('hr.attendance.department-employees');
    Route::get('/hr/attendance/employee/{employeeId}/performance', [AttendanceController::class, 'employeePerformance'])->name('hr.attendance.employee-performance');
    Route::get('/hr/attendance/department/{departmentId}/export', [AttendanceController::class, 'exportDepartmentAttendance'])->name('hr.attendance.department-export');
    Route::get('/hr/attendance/employee/{employeeId}/export', [AttendanceController::class, 'exportEmployeeAttendance'])->name('hr.attendance.employee-export');

    // Manual Attendance Entry
    Route::get('/hr/attendance/manual-entry', [AttendanceController::class, 'manualEntry'])->name('hr.attendance.manual-entry');
    Route::post('/hr/attendance/store-manual', [AttendanceController::class, 'storeManual'])->name('hr.attendance.store-manual');
    Route::post('/hr/attendance/bulk-entry', [AttendanceController::class, 'bulkEntry'])->name('hr.attendance.bulk-entry');

    // Sample data for testing (remove in production)
    // Route::get('/hr/attendance/create-sample-data', [AttendanceController::class, 'createSampleData'])->name('hr.attendance.create-sample-data');
    Route::get('/hr/attendance/delete-all-data', [AttendanceController::class, 'deleteAllAttendance'])->name('hr.attendance.delete-all-data');
});
