<?php

use Illuminate\Support\Facades\Broadcast;

/*
|--------------------------------------------------------------------------
| Broadcast Channels
|--------------------------------------------------------------------------
|
| Here you may register all of the event broadcasting channels that your
| application supports. The given channel authorization callbacks are
| used to check if an authenticated user can listen to the channel.
|
*/

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});

Broadcast::channel('vacations.{userId}', fn($user, $userId) => (int)$user->id === (int)$userId);

// قناة خاصة لتنبيهات/أحداث طلبات الإذن (Permit)
// تسمح للمستخدم المستهدف بالاشتراك في القناة الخاصة به
Broadcast::channel('permits.{userId}', fn($user, $userId) => (int)$user->id === (int)$userId);
