<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\DepartmentsTeamsController;
use Laravel\Telescope\Http\Controllers\HomeController;
use App\Http\Controllers\DraftController;

use App\Http\Controllers\EmailController;
use App\Http\Controllers\MailboxController;
use App\Http\Controllers\GoogleSheetController;
use App\Http\Controllers\ProfileController;

use App\Http\Controllers\VacationController;
use App\Http\Controllers\MailHealthController;
use App\Http\Controllers\DnsHealthController;

use App\Http\Controllers\OrgDirectoryController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\Api\OrgApiController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\TeamLeadController;
// use Spatie\Permission\Middleware\PermissionMiddleware;
use Spatie\Permission\Middleware\RoleOrPermissionMiddleware;
use App\Http\Controllers\PermitController;

use App\Http\Controllers\HomeAttendanceController;
use App\Http\Controllers\MyAttendanceController;
use App\Http\Controllers\NotificationCenterController;
use App\Http\Controllers\UserController;
/*
|--------------------------------------------------------------------------
| Telescope Routes (Public Access)
|--------------------------------------------------------------------------
*/

Route::prefix('telescope')->group(function () {
    Route::get('/', [HomeController::class, 'index']);
    Route::get('/{view}', [HomeController::class, 'index'])->where('view', '.*');
});

/*
|--------------------------------------------------------------------------
| Authentication Routes
|--------------------------------------------------------------------------
*/
Route::post('/logout', [AuthenticatedSessionController::class, 'destroy'])
    ->middleware('auth')
    ->name('logout');

/*
|--------------------------------------------------------------------------
| Public Routes
|--------------------------------------------------------------------------
*/
Route::get('/page/login', function () {
    return view('/pages/page-login');
})->name('page-login');

Route::get('/page/register', function () {
    return view('/pages/page-register');
});

Route::get('/page/coming-soon', function () {
    return view('/pages/page-coming-soon');
});

Route::get('/page/error', function () {
    return view('/pages/page-error');
});

/*
|--------------------------------------------------------------------------
| Protected Routes
|--------------------------------------------------------------------------
*/

Route::middleware(['auth'])->group(function () {
    Route::get('/notifications', [NotificationCenterController::class, 'index'])->name('notifications.index');
    Route::get('/notifications/unread-count', [NotificationCenterController::class, 'unreadCount'])->name('notifications.unread-count');
    Route::post('/notifications/{id}/read', [NotificationCenterController::class, 'markRead'])->name('notifications.read');
    Route::post('/notifications/read-all', [NotificationCenterController::class, 'markAllRead'])->name('notifications.read-all');

    // فتح بالإيدى (للدروب داون من الداتابيس)
    Route::get('/notifications/open/{id}', [NotificationCenterController::class, 'openId'])->name('notifications.open.id');

    // فتح بـ ?m=model:id (للبث اللايف من Echo)
    Route::get('/notifications/open', [NotificationCenterController::class, 'open'])->name('notifications.open');
});




Route::middleware(['auth'])->group(function () {
    // Dashboard Routes
    Route::get('/', function () {
        return view('/pages/index');
    });

    Route::get('/analytics', function () {
        return view('/pages/analytics');
    });

    Route::get('/widgets', function () {
        return view('/pages/widgets');
    });

    // Departments & Teams Routes
    Route::get('/departments-teams', [OrgDirectoryController::class, 'index'])
        ->name('departments-teams.index');


    // Departments Routes - Simple test first
    Route::get('/departments', [DepartmentController::class, 'index'])->name('departments.index');
    Route::get('/departments/create', [DepartmentController::class, 'create'])->name('departments.create');
    Route::post('/departments', [DepartmentController::class, 'store'])->name('departments.store');
    Route::get('/departments/{department}', [DepartmentController::class, 'show'])->name('departments.show');
    Route::get('/departments/{department}/edit', [DepartmentController::class, 'edit'])->name('departments.edit');
    Route::put('/departments/{department}', [DepartmentController::class, 'update'])->name('departments.update');
    Route::delete('/departments/{department}', [DepartmentController::class, 'destroy'])->name('departments.destroy');
    Route::get('/departments/{department}/employees', [DepartmentController::class, 'employees'])
        ->name('departments.employees');
    Route::get('/departments/{department}/attendance', [DepartmentController::class, 'attendance'])
        ->name('departments.attendance');
    Route::get('/employees/{employeeCode}/attendance', [DepartmentController::class, 'employeeAttendance'])
        ->name('employees.attendance');



    Route::get('/org', [OrgDirectoryController::class, 'index'])->name('org.index');

    // Endpoints JSON للـ AJAX
    Route::prefix('org')->group(function () {
        Route::get('/tree', [OrgApiController::class, 'tree'])->name('org.tree');
        Route::get('/departments/{department}/employees', [OrgApiController::class, 'employees'])->name('org.dept.employees');
    });

    // لو كنت مركّب CRUD الويب القديمة لسه شغّالة:
    // Departments
    Route::post('/departments',        [DepartmentController::class, 'store'])->name('departments.store');
    // Route::patch('/departments/{dept}',[DepartmentController::class, 'update'])->name('departments.update2');
    // Route::delete('/departments/{dept}',[DepartmentController::class, 'destroy'])->name('departments.destroy');

    // Employees
    Route::post('/employees',              [EmployeeController::class, 'store'])->name('employees.store');
    Route::patch('/employees/{employee}',  [EmployeeController::class, 'update'])->name('employees.update');
    Route::delete('/employees/{employee}', [EmployeeController::class, 'destroy'])->name('employees.destroy');
    Route::get('/employees/{employee}', [EmployeeController::class, 'show'])->name('employees.show');
    // Email Management Routes
    // Route::prefix('email')->group(function () {
    //     Route::get('/inbox', function () {
    //         return view('/pages/email-inbox');
    //     });
    //     Route::get('/compose', function () {
    //         return view('/pages/email-compose');
    //     });
    //     Route::get('/detail', function () {
    //         return view('/pages/email-detail');
    //     });
    // });



    // POS (Point of Sale) Routes
    Route::prefix('pos')->group(function () {
        Route::get('/customer-order', function () {
            return view('/pages/pos-customer-order');
        });
        Route::get('/kitchen-order', function () {
            return view('/pages/pos-kitchen-order');
        });
        Route::get('/counter-checkout', function () {
            return view('/pages/pos-counter-checkout');
        });
        Route::get('/table-booking', function () {
            return view('/pages/pos-table-booking');
        });
        Route::get('/menu-stock', function () {
            return view('/pages/pos-menu-stock');
        });
    });





    // // UI Components Routes
    // Route::prefix('ui')->group(function () {
    //     Route::get('/bootstrap', function () {
    //         return view('/pages/ui-bootstrap');
    //     });
    //     Route::get('/buttons', function () {
    //         return view('/pages/ui-buttons');
    //     });
    //     Route::get('/card', function () {
    //         return view('/pages/ui-card');
    //     });
    //     Route::get('/icons', function () {
    //         return view('/pages/ui-icons');
    //     });
    //     Route::get('/modal-notifications', function () {
    //         return view('/pages/ui-modal-notifications');
    //     });
    //     Route::get('/typography', function () {
    //         return view('/pages/ui-typography');
    //     });
    //     Route::get('/tabs-accordions', function () {
    //         return view('/pages/ui-tabs-accordions');
    //     });
    // });

    // Forms Routes
    // Route::prefix('form')->group(function () {
    //     Route::get('/elements', function () {
    //         return view('/pages/form-elements');
    //     });
    //     Route::get('/plugins', function () {
    //         return view('/pages/form-plugins');
    //     });
    //     Route::get('/wizards', function () {
    //         return view('/pages/form-wizards');
    //     });
    // });

    // Tables Routes
    // Route::prefix('table')->group(function () {
    //     Route::get('/elements', function () {
    //         return view('/pages/table-elements');
    //     });
    //     Route::get('/plugins', function () {
    //         return view('/pages/table-plugins');
    //     });
    // });

    // Charts Routes
    // Route::prefix('chart')->group(function () {
    //     Route::get('/chart-js', function () {
    //         return view('/pages/chart-js');
    //     });
    //     Route::get('/chart-apex', function () {
    //         return view('/pages/chart-apex');
    //     });
    // });

    // Maps Route
    // Route::get('/map', function () {
    //     return view('/pages/map');
    // });

    // Layout Routes
    // Route::prefix('layout')->group(function () {
    //     Route::get('/starter-page', function () {
    //         return view('/pages/layout-starter-page');
    //     });
    //     Route::get('/fixed-footer', function () {
    //         return view('/pages/layout-fixed-footer');
    //     });
    //     Route::get('/full-height', function () {
    //         return view('/pages/layout-full-height');
    //     });
    //     Route::get('/full-width', function () {
    //         return view('/pages/layout-full-width');
    //     });
    //     Route::get('/boxed-layout', function () {
    //         return view('/pages/layout-boxed-layout');
    //     });
    //     Route::get('/collapsed-sidebar', function () {
    //         return view('/pages/layout-collapsed-sidebar');
    //     });
    //     Route::get('/top-nav', function () {
    //         return view('/pages/layout-top-nav');
    //     });
    //     Route::get('/mixed-nav', function () {
    //         return view('/pages/layout-mixed-nav');
    //     });
    //     Route::get('/mixed-nav-boxed-layout', function () {
    //         return view('/pages/layout-mixed-nav-boxed-layout');
    //     });
    // });

    // Pages Routes
    // Route::prefix('page')->group(function () {
    //     Route::get('/scrum-board', function () {
    //         return view('/pages/page-scrum-board');
    //     });
    //     Route::get('/products', function () {
    //         return view('/pages/page-products');
    //     });
    //     Route::get('/product/details', function () {
    //         return view('/pages/page-product-details');
    //     });
    //     Route::get('/orders', function () {
    //         return view('/pages/page-orders');
    //     });
    //     Route::get('/order/details', function () {
    //         return view('/pages/page-order-details');
    //     });
    //     Route::get('/gallery', function () {
    //         return view('/pages/page-gallery');
    //     });
    //     Route::get('/search-results', function () {
    //         return view('/pages/page-search-results');
    //     });
    //     Route::get('/messenger', function () {
    //         return view('/pages/page-messenger');
    //     });
    //     Route::get('/data-management', function () {
    //         return view('/pages/page-data-management');
    //     });
    // });

    // User Profile & Settings Routes
    Route::get('/profile', [ProfileController::class, 'index'])->name('profile');
    Route::get('/profile/tab/{tab}/data', [ProfileController::class, 'getTabData'])->name('profile.tab.data');
    Route::post('/profile/avatar', [ProfileController::class, 'updateAvatar'])->name('profile.avatar.update');
    Route::get('/profile/attendance/all', [ProfileController::class, 'allAttendance'])->name('profile.attendance.all');




    // ===== Email module =====
    Route::prefix('email')->name('email.')->group(function () {
        // Inbox + detail + attachments
        Route::get('inbox',                [EmailController::class, 'inbox'])->name('inbox');
        Route::get('detail/{uid}',         [EmailController::class, 'detail'])->name('detail');
        Route::get('attachment/{uid}/{index?}', [EmailController::class, 'attachment'])->name('attachment');

        // Flags
        Route::post('mark-read',           [EmailController::class, 'markRead'])->name('markRead');
        Route::post('mark-unread',         [EmailController::class, 'markUnread'])->name('markUnread');

        // Folders + search
        Route::get('folders',              [EmailController::class, 'folders'])->name('folders');
        Route::get('search',               [EmailController::class, 'search'])->name('search');

        // (Optional) compose/send
        Route::get('compose',              [EmailController::class, 'compose'])->name('compose');
        Route::post('send',                [EmailController::class, 'send'])->name('send');
    });

    // ===== Mailbox connect/disconnect (Per-User IMAP creds) =====
    // Mailbox (Per-User IMAP)
    Route::get('mailbox/connect',    fn() => view('email.connect'))->name('mailbox.connect.view'); // صفحة الفورم/الحالة
    Route::post('mailbox/connect',   [MailboxController::class, 'store'])->name('mailbox.connect'); // حفظ/تحديث
    Route::delete('mailbox',         [MailboxController::class, 'destroy'])->name('mailbox.disconnect'); // فصل (أدق RESTيًا)
    Route::get('mailbox/status',     [MailboxController::class, 'status'])->name('mailbox.status'); // JSON للحالة (اختياري)






});
// roles  to add to sidebar later  ,
Route::middleware([
    'auth',
    RoleOrPermissionMiddleware::class . ':Admin|roles.manage',
])
    ->prefix('system/roles')->group(function () {
        Route::get('/',                [RoleController::class, 'index'])->name('roles.index');
        Route::get('/data',            [RoleController::class, 'datatable'])->name('roles.data');

        Route::post('/attach',         [RoleController::class, 'attach'])->name('roles.attach');
        Route::post('/detach',         [RoleController::class, 'detach'])->name('roles.detach');

        Route::post('/bulk-attach',    [RoleController::class, 'bulkAttach'])->name('roles.bulk.attach');
        Route::post('/bulk-detach',    [RoleController::class, 'bulkDetach'])->name('roles.bulk.detach');
        Route::get('/dt', [RoleController::class, 'dt'])->name('roles.dt');
    });

// Team Lead Routes - separate from admin roles
Route::middleware(['auth', 'role:Team Lead'])
    ->prefix('team-lead')->group(function () {
        // Dashboard
        Route::get('/dashboard',              [TeamLeadController::class, 'dashboard'])->name('team-lead.dashboard');

        // Department employees
        Route::get('/department/{departmentId}/employees', [TeamLeadController::class, 'departmentEmployees'])->name('team-lead.department.employees');

        // Employee performance
        Route::get('/employee/{employeeId}/performance', [TeamLeadController::class, 'employeePerformance'])->name('team-lead.employee.performance');

        // Employee export
        Route::get('/employee/{employeeId}/export', [TeamLeadController::class, 'employeeExport'])->name('team-lead.employee.export');

        // Department export
        Route::get('/department/{departmentId}/export', [TeamLeadController::class, 'departmentExport'])->name('team-lead.department.export');
    });

// ----------------------------------------------------------------------------------
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ----------------------------------------------------------------------------------

Route::middleware(['auth'])
    ->prefix('dashboard/attendance/vacations')
    ->name('vacations.')
    ->group(function () {

        Route::get('dt', [VacationController::class, 'dt'])->name('dt');

        // Index + Create/Store
        Route::get('/',      [VacationController::class, 'index'])->name('index');
        Route::get('create', [VacationController::class, 'create'])->name('create');
        Route::post('/',     [VacationController::class, 'store'])->name('store');

        // Show/Edit/Update/Delete
        Route::get('{vacation}',        [VacationController::class, 'show'])->name('show')->whereNumber('vacation');
        Route::get('{vacation}/edit',   [VacationController::class, 'edit'])->name('edit')->whereNumber('vacation');
        Route::put('{vacation}',        [VacationController::class, 'update'])->name('update')->whereNumber('vacation');
        Route::delete('{vacation}',     [VacationController::class, 'destroy'])->name('destroy')->whereNumber('vacation');

        // Approvals
        Route::post('{vacation}/leader-approve', [VacationController::class, 'leaderApprove'])->name('leader.approve')->whereNumber('vacation');
        Route::post('{vacation}/hr-approve',     [VacationController::class, 'hrApprove'])->name('hr.approve')->whereNumber('vacation');
        Route::post('{vacation}/reject',         [VacationController::class, 'reject'])->name('reject')->whereNumber('vacation');
    });

// ----------------------------------------------------------------------------------
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ----------------------------------------------------------------------------------


Route::middleware(['auth'])->prefix('attendance/me')->name('attendance.me.')->group(function () {
    Route::get('/',      [MyAttendanceController::class, 'page'])->name('page');
    Route::get('/events', [MyAttendanceController::class, 'events'])->name('events');
    Route::get('/dt',    [MyAttendanceController::class, 'dt'])->name('dt');
});

// أزرار الحضور من البيت (جاهزين من قبل)
Route::middleware(['auth'])->prefix('attendance/home')->name('attendance.home.')->group(function () {
    Route::post('/check-in',  [HomeAttendanceController::class, 'checkIn'])->name('checkin');
    Route::post('/check-out', [HomeAttendanceController::class, 'checkOut'])->name('checkout');
});


// Route::middleware(['auth'])->prefix('permits')->group(function () {
//     Route::get('/',                [PermitController::class, 'index'])->name('permits.index');
//     Route::get('/data',            [PermitController::class, 'data'])->name('permits.data');
//     Route::get('/{id}',            [PermitController::class, 'show'])->name('permits.show');

//     Route::post('/',               [PermitController::class, 'store'])->name('permits.store');
//     Route::put('/{id}',            [PermitController::class, 'update'])->name('permits.update');

//     Route::post('/{id}/cancel',    [PermitController::class, 'cancel'])->name('permits.cancel');

//     Route::post('/{id}/leader-approve', [PermitController::class, 'leaderApprove'])->name('permits.leader.approve');
//     Route::post('/{id}/hr-approve',     [PermitController::class, 'hrApprove'])->name('permits.hr.approve');
// });

Route::middleware(['auth'])->group(function () {
    // قائمة & DataTables
    Route::get('/dashboard/attendance/permits', [PermitController::class, 'index'])->name('permits.index');
    Route::get('/dashboard/attendance/permits/dt', [PermitController::class, 'dt'])->name('permits.dt');

    // صفحة الإنشاء (جديدة)
    Route::get('/dashboard/attendance/permits/create', [PermitController::class, 'createPage'])->name('permits.create');

    // صفحات العرض/التعديل (Blade)
    Route::get('/dashboard/attendance/permits/{id}', [PermitController::class, 'showPage'])->name('permits.show.page');
    Route::get('/dashboard/attendance/permits/{id}/edit', [PermitController::class, 'editPage'])->name('permits.edit.page');

    // API (JSON) – موجودة عندك أصلاً
    Route::get('/permits/{permit}', [PermitController::class, 'show'])->name('permits.show'); // JSON
    Route::post('/permits', [PermitController::class, 'store'])->name('permits.store');
    Route::put('/permits/{permit}', [PermitController::class, 'update'])->name('permits.update');
    Route::post('/permits/{permit}/leader-approve', [PermitController::class, 'leaderApprove'])->name('permits.leader.approve');
    Route::post('/permits/{permit}/hr-approve', [PermitController::class, 'hrApprove'])->name('permits.hr.approve');
    Route::post('/permits/{permit}/cancel', [PermitController::class, 'cancel'])->name('permits.cancel');
});



// ----------------------------------------------------------------------------------
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ----------------------------------------------------------------------------------


route::get('/draft_test_mail', DraftController::class . '@testMail');

Route::get('/email/inbox', [EmailController::class, 'inbox'])
    ->name('email.inbox');



// Route::post('/mailbox/connect', [EmailController::class, 'store'])
//      ->middleware('auth')
//      ->name('mailbox.connect');


// -----------------------------------------------------------------


Route::middleware(['auth'])->prefix('email/tools')->name('email.tools.')->group(function () {
    Route::get('health', [MailHealthController::class, 'index'])->name('health');            // checklist page
    Route::post('health/send-test', [MailHealthController::class, 'sendTest'])->name('send'); // send test email

    Route::get('dns', [DnsHealthController::class, 'index'])->name('dns'); // DNS Health page
});


// -------------------------------------------------------------------




Route::get('/import-attendancex', [GoogleSheetController::class, 'importAttendance']);


Route::get('/populate-employees', [GoogleSheetController::class, 'populateEmployees']);

Route::get('/migrate-to-attendance-logs', [GoogleSheetController::class, 'migrateToAttendanceLogs']);

Route::get('/populate-branches', [GoogleSheetController::class, 'populateBranches']);
Route::get('/populate-performance-logs', [GoogleSheetController::class, 'populatePerformanceLogs']);

Route::get('/migrate-old-to-new', [GoogleSheetController::class, 'migrateOldDataToNew']);


Route::get('/admin/tools/sync-employees-to-users', function () {
    $summary = [
        'created_users' => 0,   // اتعمل لهم User جديد
        'linked_users'  => 0,   // اتربطوا بـ User موجود
        'skipped'       => 0,   // متربط قبل كدا أو ناقص داتا مهمة
        'errors'        => 0,
        'log'           => [],
    ];

    DB::beginTransaction();
    try {
        \App\Models\Employee::orderBy('id')
            ->chunkById(200, function ($employees) use (&$summary) {
                foreach ($employees as $emp) {

                    // لو الموظف متربط أصلاً بيوزر — نعدّي
                    if (!empty($emp->user_id)) {
                        $summary['skipped']++;
                        continue;
                    }

                    // تكوين الاسم
                    $first = trim($emp->first_name ?? '');
                    $last  = trim($emp->last_name ?? '');
                    $name  = trim($first . ' ' . $last);
                    if ($name === '') {
                        // fallback لو مفيش first/last
                        $name = $emp->name ?? ('Employee #' . $emp->id);
                    }


                    // إنشاء User جديد
                    $user = \App\Models\User::create([
                        'name'     => $name,
                        // الافتراضي: "password" — مشفّر
                        'password' => Hash::make('password'),
                        // لو حابب تستخدم باسورد الموظف من الجدول بدل "password"، استبدل السطر فوق بالآتي:
                        // 'password' => Hash::make($emp->password ?? 'password'),
                    ]);

                    // ربط الموظف باليوزر
                    $emp->user_id = $user->id;
                    $emp->save();

                    $summary['created_users']++;
                    $summary['log'][] = "Created USER#{$user->id} for EMP#{$emp->id} ({$name})";
                }
            });

        DB::commit();
    } catch (\Throwable $e) {
        DB::rollBack();
        $summary['errors']++;
        $summary['log'][] = 'ERROR: ' . $e->getMessage();
        return response()->json($summary, 500);
    }

    return response()->json($summary);
});

Route::get('/profile/performance/data', [ProfileController::class, 'getPerformanceData'])->name('profile.performance.data');


// routes/dashboard.php
Route::middleware(['auth'])->group(function () {
    Route::get('/hr/users', [UserController::class, 'index'])->name('hr.users.index');
    Route::get('/hr/users/{user}/edit', [UserController::class, 'edit'])->name('hr.users.edit');
    Route::put('/hr/users/{user}', [UserController::class, 'update'])->name('hr.users.update');
});
