<?php
// Simple script to show recent failed jobs from failed_jobs table
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
// Boot the app
$kernel->bootstrap();
$db = $app->make('db');
$rows = $db->table('failed_jobs')->orderBy('id', 'desc')->limit(10)->get();
foreach ($rows as $r) {
    echo "id: {$r->id}\n";
    echo "connection: {$r->connection}\n";
    echo "queue: {$r->queue}\n";
    echo "failed_at: {$r->failed_at}\n";
    echo "exception:\n{$r->exception}\n";
    echo "payload:\n{$r->payload}\n";
    echo str_repeat("=", 80) . "\n";
}
if (count($rows) === 0) echo "No failed jobs.\n";
