<?php
chdir(__DIR__ . '/..');
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;

$uid = $argv[1] ?? 43;
$user = User::find($uid);
if (!$user) {
    echo "User not found: $uid\n";
    exit(1);
}

$notes = $user->notifications()->orderBy('created_at', 'desc')->limit(50)->get();
if ($notes->isEmpty()) {
    echo "No notifications for user $uid\n";
    exit(0);
}

foreach ($notes as $n) {
    $data = $n->data ?? [];
    $model = $data['model'] ?? null;
    $mid = $data['model_id'] ?? null;
    $title = $data['title'] ?? '';
    $status = $data['status'] ?? '';
    echo "{$n->id} | model={$model} model_id={$mid} status={$status} title={$title} created_at={$n->created_at}\n";
}
