<?php
chdir(__DIR__ . '/..');
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\AttendancePermit;
use App\Http\Controllers\PermitController;

$uid = 43;
$pid = 132;

Auth::loginUsingId($uid);
$user = Auth::user();
echo "Simulating as user: " . $user->id . " - " . $user->name . PHP_EOL;

$permit = AttendancePermit::find($pid);
if (!$permit) {
    echo "Permit not found: $pid\n";
    exit(1);
}

$r = Request::create('/permits/' . $pid . '/leader-approve', 'POST', [
    'decision' => 'approve',
    'leader_reason' => 'Test approve',
]);
$r->setUserResolver(fn() => $user);

$ctrl = new PermitController(app()->make(App\Services\AttendancePermitService::class));
try {
    $resp = $ctrl->leaderApprove($r, $permit);
    echo "Controller returned: ";
    if ($resp instanceof \Illuminate\Http\JsonResponse) {
        echo $resp->getContent();
    } else {
        echo get_class($resp) . PHP_EOL;
    }
} catch (\Throwable $e) {
    echo "Exception: " . get_class($e) . "\n";
    echo $e->getMessage() . "\n";
    echo $e->getTraceAsString() . "\n";
}
