<?php
// One-off debug script to inspect user/permit and policy checks
chdir(__DIR__ . '/..');
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use App\Models\AttendancePermit;
use App\Policies\AttendancePermitPolicy;
use Illuminate\Support\Facades\Gate;

$uid = $argv[1] ?? 43;
$pid = $argv[2] ?? 132;

$out = ['ok' => true, 'user_id' => $uid, 'permit_id' => $pid];

$u = User::with(['employee'])->find($uid);
$p = AttendancePermit::with(['employee'])->find($pid);

// Ensure we have actual model instances (not collections)
if ($u instanceof \Illuminate\Database\Eloquent\Collection) $u = $u->first();
if ($p instanceof \Illuminate\Database\Eloquent\Collection) $p = $p->first();

if (!$u) {
    $out['error'] = "User not found: $uid";
    echo json_encode($out, JSON_PRETTY_PRINT);
    exit(0);
}
if (!$p) {
    $out['error'] = "Permit not found: $pid";
    echo json_encode($out, JSON_PRETTY_PRINT);
    exit(0);
}

$out['user'] = [
    'id' => $u->id,
    'name' => $u->name ?? null,
    'roles' => $u->getRoleNames()->toArray(),
    'has_team_lead_role' => $u->hasRole('Team Lead'),
    'permissions' => $u->getAllPermissions()->pluck('name')->toArray(),
    'can_perm_approve' => $u->can('permits.approve'),
    'employee_id' => optional($u->employee)->id,
    'employee_dept' => optional($u->employee)->department_id,
];

$out['permit'] = [
    'id' => $p->id,
    'status' => (string) $p->status,
    'employee_id' => optional($p->employee)->id,
    'employee_dept' => optional($p->employee)->department_id,
    'requested_by_user_id' => $p->requested_by_user_id,
];

$policy = new AttendancePermitPolicy();
$out['policy_checks'] = [
    'policy_leaderApprove_direct' => $policy->leaderApprove($u, $p),
    'policy_hrApprove_direct' => $policy->hrApprove($u, $p),
    'policy_approve_direct' => $policy->approve($u, $p),
    'policy_reject_direct' => $policy->reject($u, $p),
];

$out['gate_checks'] = [
    'gate_leaderApprove' => Gate::forUser($u)->allows('leaderApprove', $p),
    'gate_hrApprove' => Gate::forUser($u)->allows('hrApprove', $p),
    'gate_approve' => Gate::forUser($u)->allows('approve', $p),
    'gate_reject' => Gate::forUser($u)->allows('reject', $p),
];

echo json_encode($out, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) . PHP_EOL;
