<?php
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use App\Models\AttendancePermit;
use App\Notifications\AttendancePermitStatusNotification;
use Illuminate\Support\Facades\Notification;

$user = User::find(43);
$permit = AttendancePermit::find(127);
if (!$user) {
    echo "User 43 not found\n";
    exit(1);
}
if (!$permit) {
    echo "Permit 127 not found\n";
    exit(1);
}

Notification::send([$user], new AttendancePermitStatusNotification($permit, 'leader_approved', $user));

echo "Enqueued notification for user 43 and permit 127\n";
