
<script>
(function () {
  const CONTAINER_ID = 'toastContainer';

  function ensureContainer() {
    let el = document.getElementById(CONTAINER_ID);
    if (!el) {
      el = document.createElement('div');
      el.id = CONTAINER_ID;
      el.className = 'toast-container position-fixed top-0 end-0 p-3';
      el.style.zIndex = 1080;
      document.body.appendChild(el);
    }
    return el;
  }

  function show({ title = 'Notice', body = '', variant = 'info', delay = 4000 } = {}) {
    const metaMap = {
      success: { emoji: '😊', label: 'Success' },
      error:   { emoji: '😡', label: 'Error' },
      warning: { emoji: '⚠️', label: 'Warning' },
      info:    { emoji: '💡', label: 'Info' },
    };
    const meta = metaMap[variant] || { emoji: '💬', label: 'Notice' };

    const wrap = ensureContainer();
    const el = document.createElement('div');
    el.className = `toast ${variant}`;
    el.setAttribute('role', 'alert');
    el.innerHTML = `
      <div class="toast-header">
        <div class="toast-avatar me-2">${meta.emoji}</div>
        <strong class="me-auto">${title || meta.label}</strong>
        <small class="text-muted">now</small>
        <button type="button" class="btn-close ms-2 mb-1" data-bs-dismiss="toast" aria-label="Close"></button>
      </div>
      <div class="toast-body">${body}</div>
      <div class="toast-progress"></div>
    `;
    el.style.setProperty('--delayms', `${delay}ms`);
    wrap.appendChild(el);

    // Bootstrap Toast
    try {
      const t = new bootstrap.Toast(el, { delay, autohide: true });
      t.show();
      el.addEventListener('hidden.bs.toast', () => el.remove());
    } catch {
      // fallback بدون Bootstrap (يختفي بعد delay)
      el.style.opacity = '1';
      setTimeout(() => {
        el.style.transition = 'opacity .2s';
        el.style.opacity = '0';
        setTimeout(() => el.remove(), 220);
      }, delay);
    }
  }

  // Helpers سريعة
  async function showFromResponse(res, fallbackTitle = 'Error') {
    let msg = `HTTP ${res.status}`;
    try {
      const ct = (res.headers.get('content-type') || '').toLowerCase();
      const data = ct.includes('application/json') ? await res.json() : await res.text();
      if (typeof data === 'string') msg = data.slice(0, 300);
      else if (data?.message) msg = data.message;
      else if (data?.errors) msg = Object.values(data.errors).flat().join('<br>');
    } catch (_) {}
    show({ title: fallbackTitle, body: msg, variant: 'error' });
  }

  // API موحّد على window
  window.toast = {
    show,
    success: (title, body = '', delay) => show({ title, body, delay, variant: 'success' }),
    error:   (title, body = '', delay) => show({ title, body, delay, variant: 'error' }),
    warning: (title, body = '', delay) => show({ title, body, delay, variant: 'warning' }),
    info:    (title, body = '', delay) => show({ title, body, delay, variant: 'info' }),
    fromResponse: showFromResponse,
  };

  // Bridge لرسائل الـ session من اللارافيل (اختياري)
  document.addEventListener('DOMContentLoaded', () => {
    const el = document.querySelector('[data-flash-success]');
    if (el?.dataset.flashSuccess) window.toast.success('Success', el.dataset.flashSuccess);
    const el2 = document.querySelector('[data-flash-error]');
    if (el2?.dataset.flashError) window.toast.error('Error', el2.dataset.flashError);
  });
})();

</script>
<?php /**PATH /opt/lampp/htdocs/2nd_epoche/new_yg_system/new-yg-1/resources/views/partial/toast-js.blade.php ENDPATH**/ ?>