<?php $__env->startPush('css'); ?>
    <style>
        /* كل الألوان جاية من متغيّرات HUD/Bootstrap اللي عندك */
        :root {
            --hud-card-bg: #28292b69;
            --hud-card-fg: var(--bs-component-color);
            --hud-card-border: var(--bs-border-color, rgba(255, 255, 255, .25));
            --hud-grid-gap: .75rem;
            /* Media Factory Identity (من الذاكرة): */
            --brand-primary: #f47b46;
            /* برتقالي */
            --brand-secondary: #0c7a7a;
            /* Teal */

            /* درجات نيون إضافية للاستخدام الاختياري */
            --neon-cyan: #2dd4ff;
            --neon-pink: #ff4d9d;
            --neon-violet: #a78bfa;
            --neon-lime: #b7f74b;
        }

        /* كارت بلمسة HUD خفيفة */
        .hud-card {
            background: var(--hud-card-bg);
            color: var(--hud-card-fg);
            border: 1px solid var(--hud-card-border);
            border-radius: var(--bs-border-radius-lg, .5rem);
        }

        .hud-card .hud-card__head {
            padding: .75rem 1rem;
            border-bottom: 1px solid var(--hud-card-border);
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: .5rem;
        }

        .hud-card .hud-card__body {
            padding: 1rem;
        }

        /* بلاطات الملخص فوق */
        .hud-tile {
            background: color-mix(in oklab, var(--hud-accent, var(--bs-theme)) 2%, var(--bs-body-bg));
            border: 1px solid color-mix(in oklab, var(--hud-accent, var(--bs-theme)) 22%, var(--hud-card-border));
            border-radius: var(--bs-border-radius, .25rem);
            padding: .625rem .75rem;
        }

        .hud-tile .label {
            color: var(--bs-secondary-color);
            font-size: .8rem;
            margin-bottom: .25rem;
        }

        .hud-tile .value {
            color: var(--bs-body-color);
            font-weight: 600;
        }

        /* شارة الحالة (تقرأ المتغيرات) */
        .hud-chip {
            --_bg: var(--bs-secondary-bg-subtle);
            --_bd: var(--bs-secondary-border-subtle);
            --_fg: var(--bs-body-color);
            display: inline-flex;
            align-items: center;
            gap: .4rem;
            padding: .25rem .55rem;
            border-radius: 999px;
            background: var(--_bg);
            border: 1px solid var(--_bd);
            color: var(--_fg);
            font-size: .78rem;
            line-height: 1;
        }

        .hud-chip .dot {
            width: .45rem;
            height: .45rem;
            border-radius: 50%;
            background: var(--_fg);
            box-shadow: 0 0 .55rem color-mix(in oklab, var(--_fg) 55%, transparent);
        }

        /* خرائط ألوان الشارة حسب الحالة */
        .hud-chip[data-variant="pending"] {
            --_bg: var(--bs-warning-bg-subtle);
            --_bd: var(--bs-warning-border-subtle);
            --_fg: var(--bs-warning);
        }

        .hud-chip[data-variant="leader_approved"] {
            --_bg: var(--bs-info-bg-subtle);
            --_bd: var(--bs-info-border-subtle);
            --_fg: var(--bs-info);
        }

        .hud-chip[data-variant="hr_approved"] {
            --_bg: var(--bs-success-bg-subtle);
            --_bd: var(--bs-success-border-subtle);
            --_fg: var(--bs-success);
        }

        .hud-chip[data-variant="rejected"] {
            --_bg: var(--bs-danger-bg-subtle);
            --_bd: var(--bs-danger-border-subtle);
            --_fg: var(--bs-danger);
        }

        /* تايملاين صغير */
        .hud-timeline {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .hud-timeline li {
            display: flex;
            gap: .55rem;
            padding: .35rem 0;
            align-items: flex-start;
            border-bottom: 1px dashed var(--hud-card-border);
        }

        .hud-timeline li:last-child {
            border-bottom: 0;
        }

        .hud-timeline .dot {
            width: .55rem;
            height: .55rem;
            border-radius: 50%;
            background: var(--bs-secondary);
            flex: 0 0 auto;
        }

        .hud-timeline .dot.on {
            background: var(--bs-success);
            box-shadow: 0 0 10px color-mix(in oklab, var(--bs-success) 45%, transparent);
        }

        .hud-timeline .txt .title {
            color: var(--bs-body-color);
        }

        .hud-timeline .txt .meta {
            color: var(--bs-secondary-color);
            font-size: .78rem;
        }

        /* أزرار متوافقة مع الثيم */
        .btn-hud {
            border-radius: var(--bs-border-radius, .25rem);
        }

        .btn-hud-outline {
            background: transparent;
            color: var(--bs-body-color);
            border: 1px solid var(--hud-card-border);
        }

        .btn-hud-solid {
            background: color-mix(in oklab, var(--hud-accent) 14%, var(--bs-body-bg));
            color: var(--bs-theme-color, #fff);
            border: 1px solid color-mix(in oklab, var(--hud-accent) 48%, var(--hud-card-border));
        }

        .btn-hud-outline:hover,
        .btn-hud-solid:hover {
            filter: brightness(1.05);
            box-shadow: 0 0 0 .15rem color-mix(in oklab, var(--hud-accent) 25%, transparent);
        }

        /* ===== Neon Tokens (قابلة للتبديل حسب البراند) ===== */


        /* قاعدة عامة للسايدبار: اختر له Accent افتراضي */
        .app-sidebar {
            --hud-accent: var(--brand-secondary);
            /* الافتراضي */
            --hud-accent-weak: color-mix(in oklab, var(--hud-accent) 20%, transparent);
            --hud-accent-mid: color-mix(in oklab, var(--hud-accent) 50%, transparent);
            --hud-accent-strong: color-mix(in oklab, var(--hud-accent) 75%, transparent);
        }

        /* Utilities لتبديل الـ Accent على مستوى السايدبار كله لو حبيت */
        .app-sidebar.accent-primary {
            --hud-accent: var(--brand-primary);
        }

        .app-sidebar.accent-secondary {
            --hud-accent: var(--brand-secondary);
        }

        .app-sidebar.accent-cyan {
            --hud-accent: var(--neon-cyan);
        }

        .app-sidebar.accent-pink {
            --hud-accent: var(--neon-pink);
        }

        .app-sidebar.accent-violet {
            --hud-accent: var(--neon-violet);
        }

        .app-sidebar.accent-lime {
            --hud-accent: var(--neon-lime);
        }

        /* ===== تلوين الهيدر والفواصل بلمسة نيون هادية ===== */
        .app-sidebar .menu-header {
            color: color-mix(in oklab, var(--hud-accent) 65%, #fff);
            text-transform: uppercase;
            letter-spacing: .06em;
            font-weight: 600;
            position: relative;
        }

        .app-sidebar .menu-header::after {
            content: "";
            display: block;
            height: 1px;
            margin-top: .35rem;
            background: linear-gradient(90deg,
                    color-mix(in oklab, var(--hud-accent) 35%, transparent),
                    transparent 60%);
            box-shadow: 0 0 12px var(--hud-accent-weak);
        }

        .app-sidebar .menu-divider {
            height: 1px;
            opacity: .6;
            background: linear-gradient(90deg,
                    transparent, color-mix(in oklab, var(--hud-accent) 25%, #777), transparent);
        }

        /* ===== العنصر ===== */
        .app-sidebar .menu-item .menu-link {
            border-radius: .55rem;
            transition: transform .14s ease, box-shadow .14s ease, background .14s ease;
            position: relative;
            outline: none;
        }

        /* أيقونة منوّرة خفيفة */
        .app-sidebar .menu-icon i {
            filter: drop-shadow(0 0 6px var(--hud-accent-weak));
        }

        /* Hover: خلفية خفيفة + توهّج بسيط */
        .app-sidebar .menu-item .menu-link:hover {
            background: color-mix(in oklab, var(--hud-accent) 12%, transparent);
            box-shadow:
                0 0 0 .075rem color-mix(in oklab, var(--hud-accent) 18%, transparent),
                inset 0 0 24px -18px var(--hud-accent-weak);
            transform: translateX(2px);
        }

        /* Active: إبراز أقوى + شُرطة جانبية نيون */
        .app-sidebar .menu-item.active>.menu-link {
            background: color-mix(in oklab, var(--hud-accent) 22%, transparent);
            box-shadow:
                0 0 22px -10px var(--hud-accent-mid),
                inset 0 0 28px -14px var(--hud-accent-mid);
        }

        .app-sidebar .menu-item.active>.menu-link::before {
            content: "";
            position: absolute;
            inset: 6px auto 6px 6px;
            width: 3px;
            border-radius: 2px;
            background: var(--hud-accent);
            box-shadow: 0 0 10px var(--hud-accent), 0 0 18px var(--hud-accent-mid);
        }

        /* Caret توهّج بسيط */
        .app-sidebar .menu-caret .caret {
            border-top-color: color-mix(in oklab, var(--hud-accent) 70%, #fff) !important;
            filter: drop-shadow(0 0 6px var(--hud-accent-weak));
        }

        /* Submenu: خط إرشادي ناعم */
        .app-sidebar .menu-submenu {
            border-left: 1px dashed color-mix(in oklab, var(--hud-accent) 18%, transparent);
            margin-left: .45rem;
            padding-left: .45rem;
        }

        /* ===== Badge نيون ===== */
        .menu-badge {
            margin-left: auto;
            /* يلزق يمين/يسار حسب RTL */
            border-radius: 999px;
            padding: .18rem .5rem;
            font-size: .75rem;
            line-height: 1;
            color: #0a0a0a;
            background: color-mix(in oklab, var(--hud-accent) 80%, #fff);
            box-shadow: 0 0 10px var(--hud-accent-weak), inset 0 0 12px var(--hud-accent-weak);
        }

        /* ===== تخصيص العنصر نفسه بـ accent مختلف (اختياري) ===== */
        /* هطبّق من الـ data-attr لو حطيناه من الـ config */
        .app-sidebar .menu-item[data-accent="primary"] {
            --hud-accent: var(--brand-primary);
        }

        .app-sidebar .menu-item[data-accent="secondary"] {
            --hud-accent: var(--brand-secondary);
        }

        .app-sidebar .menu-item[data-accent="cyan"] {
            --hud-accent: var(--neon-cyan);
        }

        .app-sidebar .menu-item[data-accent="pink"] {
            --hud-accent: var(--neon-pink);
        }

        .app-sidebar .menu-item[data-accent="violet"] {
            --hud-accent: var(--neon-violet);
        }

        .app-sidebar .menu-item[data-accent="lime"] {
            --hud-accent: var(--neon-lime);
        }

        /* اختياري: ومضة خفيفة للأيقونة في العناصر الـ active */
        @keyframes hudPulse {

            0%,
            100% {
                filter: drop-shadow(0 0 6px var(--hud-accent-weak));
            }

            50% {
                filter: drop-shadow(0 0 12px var(--hud-accent-mid));
            }
        }

        .app-sidebar .menu-item.active .menu-icon i {
            animation: hudPulse 2.2s ease-in-out infinite;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /opt/lampp/htdocs/2nd_epoche/new_yg_system/new-yg-1/resources/views/partial/theme/neon-vars.blade.php ENDPATH**/ ?>