# Mailing System Documentation

## 1. Purpose

This document outlines the architecture and functionality of the integrated mailing system. The system provides users with the ability to access an IMAP mailbox to read emails and send emails using their own SMTP credentials.

## 2. Quickstart

- **Configuration**: Ensure the `.env` file has the correct `IMAP_*` and `MAIL_*` variables set.
- **User Setup**: For sending mail, each user must have their SMTP credentials configured in their profile. The password must be stored in an encrypted format.
- **Permissions**: Users must be authenticated to access any part of the mailing system.

## 3. Capabilities

- **Inbox**: View a paginated list of emails from the INBOX folder.
- **Email Detail**: View the full body of a selected email.
- **Attachments**: (No backend logic implemented) View and download attachments from an email.
- **Marking Flags**: (No backend logic implemented) Mark emails as read, unread, flagged, etc.
- **Search**: (No backend logic implemented) Search for emails by keyword, sender, date, etc.
- **Send Email**: Compose and send new emails using the user's configured SMTP account.

## 4. High-Level Flow

1.  **Login**: User authenticates with the main application.
2.  **IMAP Connection**: The system connects to the IMAP server using a globally configured account.
3.  **Inbox Fetch**: The `EmailController` calls the `EmailService` to retrieve a list of messages from the INBOX.
4.  **Display Inbox**: The message list is displayed to the user at the `/email/inbox` endpoint.
5.  **View Detail**: User clicks on an email to view its full content.
6.  **Actions**: User can perform actions such as sending a new email.

## 5. Known Constraints & Gaps

- **Single IMAP Account**: The system is currently hardcoded to use a single, global IMAP account for fetching mail, posing a significant security risk. It does not support multi-user IMAP access.
- **Incomplete Features**: Backend logic for viewing message details, handling attachments, searching, and managing flags is missing.
- **No Caching**: All data is fetched live from the IMAP server, which may impact performance on large mailboxes.
- **Security**: Hardcoded credentials in config and service files are a major security vulnerability.
