# Mailing System Architecture

## 1. Sequence Diagrams (Mermaid)

### Inbox Listing

```mermaid
sequenceDiagram
    participant User
    participant Browser
    participant EmailController
    participant EmailService
    participant IMAPServer

    User->>Browser: GET /email/inbox
    Browser->>EmailController: inbox()
    EmailController->>EmailService: getInboxMessages()
    EmailService->>IMAPServer: Connect & Authenticate (Hardcoded Credentials)
    EmailService->>IMAPServer: Open Folder 'INBOX'
    EmailService->>IMAPServer: Fetch Messages (PEEK)
    IMAPServer-->>EmailService: Return Message Collection
    EmailService-->>EmailController: Return Message Collection
    EmailController->>Browser: Render 'email-inbox' view with messages
    Browser-->>User: Display Inbox
```

### Message Detail (Not Implemented)

*This flow outlines the intended, but not currently implemented, logic.*

```mermaid
sequenceDiagram
    participant User
    participant Browser
    participant EmailController
    participant EmailService
    participant IMAPServer

    User->>Browser: GET /email/detail/{uid}
    Browser->>EmailController: detail(uid)
    EmailController->>EmailService: getMessageByUID(uid)
    EmailService->>IMAPServer: Fetch Message by UID
    IMAPServer-->>EmailService: Return Full Message Object
    EmailService-->>EmailController: Return Message Object
    EmailController->>Browser: Render 'email-detail' view with message
    Browser-->>User: Display Email
```

### Mark as Read/Unread (Not Implemented)

```mermaid
sequenceDiagram
    participant User
    participant Browser
    participant EmailController
    participant EmailService
    participant IMAPServer

    User->>Browser: POST /email/mark-read (via AJAX)
    Browser->>EmailController: markAsRead(uid)
    EmailController->>EmailService: setFlag(['\\Seen'], uid)
    EmailService->>IMAPServer: Set Flag '\\Seen' on message
    IMAPServer-->>EmailService: Success/Failure
    EmailService-->>EmailController: Return status
    EmailController-->>Browser: JSON Response
```

## 2. Component Diagram

```mermaid
componentDiagram
    package "Browser" {
        [Inbox View]
        [Detail View]
        [Compose View]
    }

    package "Laravel App" {
        package "Controllers" {
            [EmailController]
        }
        package "Services" {
            [EmailService]
        }
        package "Routes" {
            [web.php]
        }
        package "Configuration" {
            [imap.php]
            [mail.php]
            [.env]
        }
        package "Models" {
            [User]
        }
    }

    package "External" {
        [IMAP Server]
        [SMTP Server]
    }

    [Inbox View] --> [EmailController]
    [Detail View] --> [EmailController]
    [Compose View] --> [EmailController]
    [EmailController] --> [EmailService]
    [EmailController] --> [User]
    [web.php] --> [EmailController]
    [EmailService] --> [IMAP Server]
    [EmailService] --> [SMTP Server]
    [EmailService] --> [imap.php]
    [EmailService] --> [mail.php]
    [EmailService] --> [User]
```

## 3. State Management

- **IMAP Only**: All email data (messages, folders, flags) is stored exclusively on the IMAP server. There is no database-level caching or persistence.
- **In-Memory**: Message collections from the IMAP server are held in memory for the duration of a single request and then discarded.
- **User Credentials**: The user's SMTP password is the only piece of mailing system data persisted in the database (`users.email_password`) and is encrypted.

```