# Development Backlog

This document contains a prioritized list of tasks to improve the mailing system, fix gaps, and add new features.

## Short-Term (Immediate Priorities)

- **[Security] Remove Hardcoded Credentials**: Immediately remove all hardcoded IMAP and SMTP credentials from `config/imap.php` and `app/Services/EmailService.php`.
- **[Bug] Implement Per-User IMAP Accounts**: Modify the `EmailService` to use the authenticated user's stored (and encrypted) credentials to connect to IMAP. This is essential for basic functionality and security.
- **[Feature] Implement Message Detail View**: Create the controller logic to fetch a single email by its UID and pass it to the `email-detail` view.
- **[Security] Sanitize HTML Email Body**: Integrate a library like `HTMLPurifier` to sanitize all HTML content before rendering it in the browser to prevent XSS attacks.
- **[Logging] Mask Sensitive Data in Logs**: Configure Telescope to mask all PII and secrets from being logged.

## Mid-Term (Core Feature Enhancements)

- **[Feature] Implement Background Sync**: Create a queued job to periodically sync user mailboxes with the IMAP server and populate a local cache. This will dramatically improve performance.
- **[Feature] Implement Caching Policy**: Build the database schema and logic for caching messages and attachments as outlined in `data-model.md`.
- **[Feature] Folder Switching**: Add a UI element and the corresponding backend logic to allow users to view different IMAP folders (Sent, Drafts, Junk, etc.).
- **[Feature] Attachment Handling**: Implement logic to list attachments in the detail view and allow users to download them. Use a streaming approach for large files.
- **[Feature] Basic Search**: Implement search functionality to filter emails by keyword, sender, and subject.
- **[Feature] Flag Management**: Add functionality to mark emails as read/unread, flagged, and deleted.

## Long-Term (New Modules & Advanced Features)

- **[Feature] Compose/Reply/Forward**: Build out the full email composition suite, including:
    - Replying to and forwarding messages.
    - Rich text editor for composing emails.
    - Handling inline images.
- **[Feature] User Signatures**: Allow users to create and manage their own email signatures.
- **[Feature] Email Templates**: Create a system for reusable email templates.
- **[Security] S/MIME or PGP**: Investigate the possibility of adding support for client-side encryption and digital signatures.
- **[Admin] Auditing**: Create a logging system to audit when users access mailboxes or send emails, for security and compliance purposes.
