# Email System Endpoints

This document lists all HTTP endpoints related to the mailing system.

## 1. Route Definitions

All email routes are defined in `routes/web.php` and are protected by the `auth` middleware group.

| Method | URI                               | Controller Action         | Route Name      | Description                                         |
|--------|-----------------------------------|---------------------------|-----------------|-----------------------------------------------------|
| GET    | `/email/inbox`                    | `EmailController@inbox`   | `email.inbox`   | Displays the email inbox.                           |
| GET    | `/email/compose`                  | `EmailController@compose` | `email.compose` | Displays the email composition form.                |
| POST   | `/email/send`                     | `EmailController@send`    | `email.send`    | Sends the new email.                                |
| GET    | `/email/detail/{uid}`             | *(Not Implemented)*       | *(None)*        | Intended to show a single email. Currently static.  |
| GET    | `/email/attachments/{uid}/{part?}`| *(Not Implemented)*       | *(None)*        | Intended to download an attachment.                 |
| GET    | `/email/search`                   | *(Not Implemented)*       | *(None)*        | Intended for searching emails.                      |
| POST   | `/email/mark-read`                | *(Not Implemented)*       | *(None)*        | Intended to mark an email as read.                  |
| DELETE | `/email/{uid}`                    | *(Not Implemented)*       | *(None)*        | Intended to delete an email.                        |

## 2. Middleware & Guards

- **`auth`**: All routes listed above require the user to be authenticated. This is enforced in `routes/web.php` via `Route::middleware(['auth'])->group(...)`.
- **CSRF**: As these are web routes, they are automatically protected by Laravel's CSRF protection middleware.

## 3. Query Parameters & Pagination

- **`GET /email/inbox`**: The `inbox()` method in `EmailController` currently fetches a hardcoded limit of 50 messages. There is no pagination implemented. A `?page=` parameter could be added to support pagination.
- **`GET /email/search`**: A potential implementation would use query parameters like `?query=...&from=...&date=...` to filter results.

## 4. Request Payloads

- **`POST /email/send`**: Expects a standard form submission with the following fields:
  - `to` (string, required, email)
  - `cc` (string, nullable)
  - `bcc` (string, nullable)
  - `subject` (string, required)
  - `body` (string, required, HTML content)
  - `_token` (string, required, CSRF token)
