# Logic Deconstruction

## 1. Service Layer (`EmailService.php`)

### IMAP Connection (`connectDynamicUser`)

- **Purpose**: To establish a connection to the IMAP server.
- **Process**:
    1.  Retrieves the currently authenticated user (`Auth::user()`).
    2.  Instantiates the `Webklex\IMAP\Facades\Client`.
    3.  **CRITICAL FLAW**: The connection details (`host`, `port`, `username`, `password`) are **hardcoded**. It does not use the authenticated user's credentials for the IMAP connection. The method name is misleading.
    4.  It connects to the server using these hardcoded values.
- **Error Handling**: There is no explicit `try...catch` block around the `connect()` call, so any connection failures will throw an exception.

### Message Fetching (`getInboxMessages`)

- **Purpose**: To retrieve a list of messages from the INBOX folder.
- **Process**:
    1.  Gets the folder object for `INBOX`.
    2.  Retrieves all messages from the folder.
    3.  A hardcoded limit of 50 messages is applied.
    4.  Returns a `Webklex\PHPIMAP\Support\MessageCollection`.
- **Body/Attachment Handling**: The default configuration (`imap.php`) is set to `FT_PEEK`, which fetches message metadata without marking them as seen. The full body is fetched by default.

### Single Message Retrieval (`getMessageByUID`)

- **Purpose**: To get a single message by its UID.
- **Process**:
    1.  Gets the folder object for `INBOX`.
    2.  Uses the `getMessage($uid)` method from the `webklex` library to retrieve the specific message.
- **Note**: This method is not currently used by any controller.

### Flag Management

- There is no implemented logic for setting or unsetting flags like `\Seen`, `\Answered`, or `\Deleted`.

### Email Sending (`sendEmail`)

- **Purpose**: To send an email using the user's SMTP credentials.
- **Process**:
    1.  Retrieves the authenticated user.
    2.  Creates a new Symfony Mailer transport (`EsmtpTransport`).
    3.  Sets the transport's username and password by using the user's `email` and **decrypting** the `email_password` from the database.
    4.  Constructs and sends the email.
- **HTML/Text Handling**: It sends only an HTML body (`->html($body)`). No plain text part is provided.

## 2. Controller Orchestration (`EmailController.php`)

- **`inbox()`**: 
    1.  Instantiates the `EmailService`.
    2.  Calls `getInboxMessages()` to get the list of emails.
    3.  Passes the resulting `MessageCollection` to the `pages.email-inbox` view.
- **`compose()`**: 
    1.  Simply returns the `pages.email-compose` view without any data.
- **`send()`**:
    1.  Validates the incoming request for `to`, `subject`, and `body`.
    2.  Dynamically creates a Symfony Mailer transport using the user's credentials (retrieved and decrypted at the moment of sending).
    3.  Constructs and sends the email.
    4.  Redirects back to the inbox with a success message.

## 3. UI/Blade Logic

- **`email-inbox.blade.php`**:
    - Loops through the `$messages` collection passed from the controller.
    - For each message, it displays the sender (`$message->getFrom()[0]->mail`), subject (`$message->getSubject()`), and a snippet (not explicitly shown, but could be `$message->getTextBody()`).
    - The date of the message is also displayed.
- **`email-detail.blade.php`**:
    - This is a static template. It does not receive a message object from the controller and contains placeholder content.
- **Localization/UTF-8**: There is no explicit handling for localization or right-to-left text. However, the `webklex` library is configured to use `utf-8` decoding for message subjects and attachment names, which provides good support for non-ASCII characters.
